/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.ForGraph;
import guru.nidi.graphviz.attribute.MapAttributes;
import guru.nidi.graphviz.attribute.SingleAttributes;

public final class Rank {
    private Rank() {
    }

    public static GraphRank dir(RankDir dir) {
        return new GraphRank(dir, null, false, true, false);
    }

    public static GraphRank sep(double sep) {
        return new GraphRank(null, sep, false, true, false);
    }

    public static GraphRank sepEqually(double sep) {
        return new GraphRank(null, sep, true, true, false);
    }

    public static GraphRank newRank() {
        return new GraphRank(null, null, false, true, true);
    }

    public static Attributes<ForGraph> inSubgraph(RankType rankType) {
        return new SubgraphRank(rankType);
    }

    public static enum RankDir {
        TOP_TO_BOTTOM("TB"),
        BOTTOM_TO_TOP("BT"),
        LEFT_TO_RIGHT("LR"),
        RIGHT_TO_LEFT("RL");

        final String value;

        private RankDir(String value) {
            this.value = value;
        }
    }

    public static enum RankType {
        SAME("same"),
        MIN("min"),
        MAX("max"),
        SOURCE("source"),
        SINK("sink");

        final String value;

        private RankType(String value) {
            this.value = value;
        }
    }

    public static class GraphRank
    implements Attributes<ForGraph> {
        private final RankDir dir;
        private final Double sep;
        private final boolean equally;
        private final boolean cluster;
        private final boolean newRank;

        GraphRank(RankDir dir, Double sep, boolean equally, boolean cluster, boolean newRank) {
            this.dir = dir;
            this.sep = sep;
            this.equally = equally;
            this.cluster = cluster;
            this.newRank = newRank;
        }

        public GraphRank dir(RankDir dir) {
            return new GraphRank(dir, this.sep, this.equally, this.cluster, this.newRank);
        }

        public GraphRank sep(double sep) {
            return new GraphRank(this.dir, sep, this.equally, this.cluster, this.newRank);
        }

        public GraphRank sepEqually(double sep) {
            return new GraphRank(this.dir, sep, true, this.cluster, this.newRank);
        }

        public GraphRank noCluster() {
            return this.cluster(false);
        }

        public GraphRank cluster(boolean cluster) {
            return new GraphRank(this.dir, this.sep, this.equally, cluster, this.newRank);
        }

        public GraphRank newRank() {
            return this.newRank(true);
        }

        public GraphRank newRank(boolean newRank) {
            return new GraphRank(this.dir, this.sep, this.equally, this.cluster, newRank);
        }

        @Override
        public Attributes<? super ForGraph> applyTo(MapAttributes<? super ForGraph> attrs) {
            if (this.dir != null) {
                attrs.add("rankdir", this.dir.value);
            }
            if (!this.cluster) {
                attrs.add("clusterrank", "global");
            }
            if (this.sep != null || this.equally) {
                attrs.add("ranksep", (this.sep == null ? "" : this.sep) + (this.equally ? " equally" : ""));
            }
            if (this.newRank) {
                attrs.add("newrank", true);
            }
            return attrs;
        }
    }

    private static class SubgraphRank
    extends SingleAttributes<String, ForGraph> {
        SubgraphRank(RankType rankType) {
            super("rank", rankType.value);
        }
    }
}

