/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.ForNode;
import guru.nidi.graphviz.attribute.MapAttributes;
import guru.nidi.graphviz.attribute.NodeAttr;

public final class Size
implements Attributes<ForNode> {
    private final Mode mode;
    private final Double width;
    private final Double height;
    private final Double marginX;
    private final Double marginY;

    private Size(Mode mode, Double width, Double height, Double marginX, Double marginY) {
        this.mode = mode;
        this.width = width;
        this.height = height;
        this.marginX = marginX;
        this.marginY = marginY;
    }

    public static Size mode(Mode mode) {
        return new Size(mode, null, null, null, null);
    }

    public static Size std() {
        return new Size(null, null, null, null, null);
    }

    public Size size(double width, double height) {
        return new Size(this.mode, width, height, this.marginX, this.marginY);
    }

    public Size margin(double marginX, double marginY) {
        return new Size(this.mode, this.width, this.height, marginX, marginY);
    }

    @Override
    public Attributes<? super ForNode> applyTo(MapAttributes<? super ForNode> attrs) {
        if (this.mode != null) {
            NodeAttr.nodeAttr("fixedsize", this.mode.value).applyTo(attrs);
        }
        if (this.width != null) {
            NodeAttr.nodeAttr("width", this.width).applyTo(attrs);
            NodeAttr.nodeAttr("height", this.height).applyTo(attrs);
        }
        if (this.marginX != null) {
            NodeAttr.nodeAttr("margin", this.marginX + "," + this.marginY).applyTo(attrs);
        }
        return attrs;
    }

    public static enum Mode {
        FIXED("true"),
        MINIMUM("false"),
        SHAPE("shape");

        final String value;

        private Mode(String value) {
            this.value = value;
        }
    }
}

