/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.IOFunction;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public final class EngineResult {
    private final File file;
    private final String string;

    private EngineResult(File file, String string) {
        this.file = file;
        this.string = string;
    }

    public static EngineResult fromFile(File file) {
        return new EngineResult(file, null);
    }

    public static EngineResult fromString(String string) {
        return new EngineResult(null, string);
    }

    public EngineResult mapString(Function<String, String> mapper) {
        return this.string == null ? this : EngineResult.fromString(mapper.apply(this.string));
    }

    public void consume(Consumer<File> fileConsumer, Consumer<String> stringConsumer) {
        if (this.string == null) {
            fileConsumer.accept(this.file);
        } else {
            stringConsumer.accept(this.string);
        }
        this.close();
    }

    public <T> T map(Function<File, T> fileMapper, Function<String, T> stringMapper) {
        T res = this.string == null ? fileMapper.apply(this.file) : stringMapper.apply(this.string);
        this.close();
        return res;
    }

    <T> T mapIO(IOFunction<File, T> fileMapper, IOFunction<String, T> stringMapper) throws IOException {
        T res = this.string == null ? fileMapper.apply(this.file) : stringMapper.apply(this.string);
        this.close();
        return res;
    }

    private void close() {
        if (this.file != null) {
            this.file.delete();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EngineResult that = (EngineResult)o;
        return Objects.equals(this.file, that.file) && Objects.equals(this.string, that.string);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.string);
    }

    public String toString() {
        return "EngineResult{file=" + this.file + ", string='" + this.string + '\'' + '}';
    }
}

