/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.actions.impl;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.UserRequirement;
import org.contextmapper.dsl.ide.actions.CMLCodeAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.Command;

public class DeriveSubdomainFromUserRequirementsAction
implements CMLCodeAction {
    private CMLResource cmlResource;
    private List<EObject> editorSelection;

    public DeriveSubdomainFromUserRequirementsAction(CMLResource cmlResource, List<EObject> editorSelection) {
        this.cmlResource = cmlResource;
        this.editorSelection = editorSelection;
    }

    @Override
    public boolean isApplicable() {
        return !this.getSelectedUserRequirements().isEmpty();
    }

    @Override
    public Command getCommand() {
        LinkedList commandArguments = Lists.newLinkedList();
        commandArguments.add(this.cmlResource.getURI().toString());
        commandArguments.addAll(this.getSelectedUserRequirements().stream().map(ur -> ur.getName()).collect(Collectors.toSet()));
        return new Command("Derive Subdomain From User Requirements", "cml.ar.deriveSubdomainFromURs.proxy", (List)commandArguments);
    }

    private Set<UserRequirement> getSelectedUserRequirements() {
        return this.editorSelection.stream().filter(o -> o instanceof UserRequirement).map(o -> (UserRequirement)o).collect(Collectors.toSet());
    }
}

