/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.actions.impl;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.ide.actions.CMLCodeAction;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.Command;

public class SplitAggregateByEntitiesAction
implements CMLCodeAction {
    private CMLResource cmlResource;
    private List<EObject> editorSelection;

    public SplitAggregateByEntitiesAction(CMLResource cmlResource, List<EObject> editorSelection) {
        this.cmlResource = cmlResource;
        this.editorSelection = editorSelection;
    }

    @Override
    public boolean isApplicable() {
        Set<Aggregate> aggregates = this.getSelectedAggregates();
        if (aggregates.isEmpty() || aggregates.size() > 1) {
            return false;
        }
        Aggregate aggregate = aggregates.iterator().next();
        List entities = aggregate.getDomainObjects().stream().filter(so -> so instanceof Entity).collect(Collectors.toList());
        return entities.size() > 1;
    }

    @Override
    public Command getCommand() {
        LinkedList commandArguments = Lists.newLinkedList();
        commandArguments.add(this.cmlResource.getURI().toString());
        commandArguments.add(this.getSelectedAggregate().getName());
        return new Command("Split Aggregate By Entities", "cml.ar.splitAggregateByEntities", (List)commandArguments);
    }

    private Aggregate getSelectedAggregate() {
        Set<Aggregate> aggregates = this.getSelectedAggregates();
        return aggregates.iterator().next();
    }

    private Set<Aggregate> getSelectedAggregates() {
        return this.editorSelection.stream().filter(o -> o instanceof Aggregate).map(o -> (Aggregate)o).collect(Collectors.toSet());
    }
}

