/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.actions.impl;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.Partnership;
import org.contextmapper.dsl.ide.actions.CMLCodeAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.Command;

public class SwitchFromPartnershipToSharedKernelAction
implements CMLCodeAction {
    private CMLResource cmlResource;
    private List<EObject> editorSelection;

    public SwitchFromPartnershipToSharedKernelAction(CMLResource cmlResource, List<EObject> editorSelection) {
        this.cmlResource = cmlResource;
        this.editorSelection = editorSelection;
    }

    @Override
    public boolean isApplicable() {
        return this.getSelectedPartnerships().size() == 1;
    }

    @Override
    public Command getCommand() {
        LinkedList commandArguments = Lists.newLinkedList();
        Partnership selectedPartnership = this.getSelectedPartnership();
        commandArguments.add(this.cmlResource.getURI().toString());
        commandArguments.add(selectedPartnership.getParticipant1().getName());
        commandArguments.add(selectedPartnership.getParticipant2().getName());
        return new Command("Change to Shared Kernel", "cml.ar.switchPartnershipToSharedKernel", (List)commandArguments);
    }

    private Partnership getSelectedPartnership() {
        return this.getSelectedPartnerships().iterator().next();
    }

    private Set<Partnership> getSelectedPartnerships() {
        return this.editorSelection.stream().filter(o -> o instanceof Partnership).map(o -> (Partnership)o).collect(Collectors.toSet());
    }
}

