/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.actions.impl;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.SharedKernel;
import org.contextmapper.dsl.ide.actions.CMLCodeAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.Command;

public class SwitchFromSharedKernelToPartnershipAction
implements CMLCodeAction {
    private CMLResource cmlResource;
    private List<EObject> editorSelection;

    public SwitchFromSharedKernelToPartnershipAction(CMLResource cmlResource, List<EObject> editorSelection) {
        this.cmlResource = cmlResource;
        this.editorSelection = editorSelection;
    }

    @Override
    public boolean isApplicable() {
        return this.getSelectedSharedKernels().size() == 1;
    }

    @Override
    public Command getCommand() {
        LinkedList commandArguments = Lists.newLinkedList();
        SharedKernel selectedSharedKernel = this.getSelectedSharedKernel();
        commandArguments.add(this.cmlResource.getURI().toString());
        commandArguments.add(selectedSharedKernel.getParticipant1().getName());
        commandArguments.add(selectedSharedKernel.getParticipant2().getName());
        return new Command("Change to Partnership", "cml.ar.switchSharedKernelToPartnership", (List)commandArguments);
    }

    private SharedKernel getSelectedSharedKernel() {
        return this.getSelectedSharedKernels().iterator().next();
    }

    private Set<SharedKernel> getSelectedSharedKernels() {
        return this.editorSelection.stream().filter(o -> o instanceof SharedKernel).map(o -> (SharedKernel)o).collect(Collectors.toSet());
    }
}

