/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.commands.impl.refactoring;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Set;
import org.contextmapper.dsl.ide.commands.impl.refactoring.AbstractRefactoringCommand;
import org.contextmapper.dsl.ide.edit.WorkspaceEditRecorder;
import org.contextmapper.dsl.refactoring.DeriveBoundedContextFromSubdomains;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.eclipse.lsp4j.ExecuteCommandParams;

public class DeriveBoundedContextFromSubdomainsCommand
extends AbstractRefactoringCommand {
    public DeriveBoundedContextFromSubdomainsCommand(WorkspaceEditRecorder editRecorder) {
        super(editRecorder);
    }

    @Override
    protected SemanticCMLRefactoring getRefactoring(ExecuteCommandParams params) {
        JsonArray refactoringParams = (JsonArray)params.getArguments().get(1);
        JsonPrimitive boundedContextName = (JsonPrimitive)refactoringParams.get(0);
        JsonArray selectedSubdomainsArray = (JsonArray)refactoringParams.get(1);
        HashSet selectedSubdomains = Sets.newHashSet();
        for (JsonElement element : selectedSubdomainsArray) {
            selectedSubdomains.add(element.getAsString());
        }
        return new DeriveBoundedContextFromSubdomains(boundedContextName.getAsString(), (Set)selectedSubdomains);
    }
}

