/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.hover;

import org.contextmapper.dsl.hover.CMLHoverTextProvider;
import org.contextmapper.dsl.hover.impl.MarkdownHoverTextProvider4CML;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EnumLiteralDeclaration;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.hover.HoverContext;
import org.eclipse.xtext.ide.server.hover.HoverService;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;

public class CMLHoverService
extends HoverService {
    private CMLHoverTextProvider textProvider = new MarkdownHoverTextProvider4CML();

    public String getContents(EObject element) {
        if (element instanceof Keyword) {
            return this.textProvider.getHoverText(((Keyword)element).getValue());
        }
        if (element instanceof EnumLiteralDeclaration) {
            return this.textProvider.getHoverText(((EnumLiteralDeclaration)element).getEnumLiteral().toString());
        }
        return "";
    }

    protected HoverContext createContext(Document document, XtextResource resource, int offset) {
        if (resource.getParseResult() != null && resource.getParseResult().getRootNode() != null) {
            ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset((INode)resource.getParseResult().getRootNode(), (int)offset);
            if (this.isGrammarElementKeyword(leaf)) {
                return new HoverContext(document, resource, offset, leaf.getTextRegion(), (EObject)((Keyword)leaf.getGrammarElement()));
            }
            if (this.isGrammarElementEnumLiteral(leaf)) {
                return new HoverContext(document, resource, offset, leaf.getTextRegion(), (EObject)((EnumLiteralDeclaration)leaf.getGrammarElement()));
            }
        }
        return super.createContext(document, resource, offset);
    }

    private boolean isGrammarElementDefined(ILeafNode leaf) {
        return leaf != null && leaf.getGrammarElement() != null;
    }

    private boolean isGrammarElementKeyword(ILeafNode leaf) {
        return this.isGrammarElementDefined(leaf) && leaf.getGrammarElement() instanceof Keyword;
    }

    private boolean isGrammarElementEnumLiteral(ILeafNode leaf) {
        return this.isGrammarElementDefined(leaf) && leaf.getGrammarElement() instanceof EnumLiteralDeclaration;
    }
}

