/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.actions;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.LinkedList;
import java.util.List;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.ide.actions.CMLActionRegistry;
import org.contextmapper.dsl.ide.actions.SelectionContextResolver;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class CMLActionService
implements ICodeActionService2 {
    @Inject
    private SelectionContextResolver selectionResolver;
    @Inject
    private CMLActionRegistry actionRegistry;

    public List<Either<Command, CodeAction>> getCodeActions(ICodeActionService2.Options options) {
        boolean _not;
        CodeActionParams params = options.getCodeActionParams();
        Range currentSelectionRange = params.getRange();
        Position startPosition = currentSelectionRange.getStart();
        Position endPosition = currentSelectionRange.getEnd();
        XtextResource _resource = options.getResource();
        CMLResource resource = new CMLResource((Resource)_resource);
        List<EObject> selectedObjects = this.selectionResolver.resolveAllSelectedEObjects(resource, options.getDocument().getOffSet(startPosition), options.getDocument().getOffSet(endPosition));
        LinkedList allActions = Lists.newLinkedList();
        Functions.Function1 _function = it -> Either.forLeft((Object)it);
        allActions.addAll(ListExtensions.map(this.actionRegistry.getApplicableActionCommands(resource, selectedObjects), (Functions.Function1)_function));
        boolean _isEmpty = params.getContext().getDiagnostics().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            List _diagnostics = params.getContext().getDiagnostics();
            for (Diagnostic d : _diagnostics) {
                allActions.addAll(this.actionRegistry.getApplicableQuickfixes(d, options));
            }
        }
        return allActions;
    }
}

