/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.actions.impl;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLModelObjectsResolvingHelper;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.ide.actions.CMLCodeAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.Command;
import org.eclipse.xtext.EcoreUtil2;

public class MergeAggregatesAction
implements CMLCodeAction {
    private CMLResource cmlResource;
    private List<EObject> editorSelection;

    public MergeAggregatesAction(CMLResource cmlResource, List<EObject> editorSelection) {
        this.cmlResource = cmlResource;
        this.editorSelection = editorSelection;
    }

    @Override
    public boolean isApplicable() {
        Set<Aggregate> aggregates = this.getSelectedAggregates();
        if (aggregates.isEmpty() || aggregates.size() > 1) {
            return false;
        }
        BoundedContext parentContext = new CMLModelObjectsResolvingHelper(this.cmlResource.getContextMappingModel()).resolveBoundedContext(aggregates.iterator().next());
        return EcoreUtil2.eAllOfType((EObject)parentContext, Aggregate.class).size() > 1;
    }

    @Override
    public Command getCommand() {
        Aggregate aggregate = this.getSelectedAggregate();
        BoundedContext parentContext = new CMLModelObjectsResolvingHelper(this.cmlResource.getContextMappingModel()).resolveBoundedContext(aggregate);
        LinkedList commandArguments = Lists.newLinkedList();
        commandArguments.add(this.cmlResource.getURI().toString());
        commandArguments.add(aggregate.getName());
        commandArguments.addAll(EcoreUtil2.eAllOfType((EObject)parentContext, Aggregate.class).stream().map(agg -> agg.getName()).filter(name -> !name.equals(aggregate.getName())).collect(Collectors.toSet()));
        return new Command("Merge Aggregates", "cml.ar.mergeAggregates.proxy", (List)commandArguments);
    }

    private Aggregate getSelectedAggregate() {
        return this.getSelectedAggregates().iterator().next();
    }

    private Set<Aggregate> getSelectedAggregates() {
        return this.editorSelection.stream().filter(o -> o instanceof Aggregate).map(o -> (Aggregate)o).collect(Collectors.toSet());
    }
}

