/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.actions.impl;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.ide.actions.CMLCodeAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.Command;
import org.eclipse.xtext.EcoreUtil2;

public class MergeBoundedContextsAction
implements CMLCodeAction {
    private CMLResource cmlResource;
    private List<EObject> editorSelection;

    public MergeBoundedContextsAction(CMLResource cmlResource, List<EObject> editorSelection) {
        this.cmlResource = cmlResource;
        this.editorSelection = editorSelection;
    }

    @Override
    public boolean isApplicable() {
        Set<BoundedContext> boundedContexts = this.getSelectedBoundedContexts();
        if (boundedContexts.isEmpty() || boundedContexts.size() > 1) {
            return false;
        }
        EObject root = EcoreUtil2.getRootContainer((EObject)((EObject)boundedContexts.iterator().next()));
        if (!(root instanceof ContextMappingModel)) {
            return false;
        }
        ContextMappingModel model = (ContextMappingModel)root;
        return model.getBoundedContexts().size() > 1;
    }

    @Override
    public Command getCommand() {
        BoundedContext firstContext = this.getSelectedBoundedContext();
        ContextMappingModel model = (ContextMappingModel)EcoreUtil2.getRootContainer((EObject)firstContext);
        LinkedList commandArguments = Lists.newLinkedList();
        commandArguments.add(this.cmlResource.getURI().toString());
        commandArguments.add(firstContext.getName());
        commandArguments.addAll(EcoreUtil2.eAllOfType((EObject)model, BoundedContext.class).stream().map(bc -> bc.getName()).filter(name -> !name.equals(firstContext.getName())).collect(Collectors.toSet()));
        return new Command("Merge Bounded Contexts", "cml.ar.mergeBoundedContexts.proxy", (List)commandArguments);
    }

    private BoundedContext getSelectedBoundedContext() {
        return this.getSelectedBoundedContexts().iterator().next();
    }

    private Set<BoundedContext> getSelectedBoundedContexts() {
        return this.editorSelection.stream().filter(o -> o instanceof BoundedContext).map(o -> (BoundedContext)o).collect(Collectors.toSet());
    }
}

