/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.actions.impl;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.BoundedContextType;
import org.contextmapper.dsl.ide.actions.CMLCodeAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.Command;

public class SplitSystemIntoSubsystemsAction
implements CMLCodeAction {
    private CMLResource cmlResource;
    private List<EObject> editorSelection;

    public SplitSystemIntoSubsystemsAction(CMLResource cmlResource, List<EObject> editorSelection) {
        this.cmlResource = cmlResource;
        this.editorSelection = editorSelection;
    }

    @Override
    public boolean isApplicable() {
        return this.getSelectedSystemBoundedContexts().size() == 1;
    }

    @Override
    public Command getCommand() {
        LinkedList commandArguments = Lists.newLinkedList();
        commandArguments.add(this.cmlResource.getURI().toString());
        commandArguments.add(this.getSelectedSystemBoundedContext().getName());
        return new Command("Split System Context Into Subsystems", "cml.ar.splitSystemContextIntoSubsystems.proxy", (List)commandArguments);
    }

    private BoundedContext getSelectedSystemBoundedContext() {
        return this.getSelectedSystemBoundedContexts().iterator().next();
    }

    private Set<BoundedContext> getSelectedSystemBoundedContexts() {
        return this.editorSelection.stream().filter(o -> o instanceof BoundedContext).map(o -> (BoundedContext)o).filter(bc -> bc.getType() == BoundedContextType.SYSTEM).collect(Collectors.toSet());
    }
}

