/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.commands;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.contextmapper.dsl.ide.commands.CMLResourceCommand;
import org.contextmapper.dsl.ide.commands.impl.generation.ContextMapGenerationCommand;
import org.contextmapper.dsl.ide.commands.impl.generation.GenericTextFileGenerationCommand;
import org.contextmapper.dsl.ide.commands.impl.generation.MDSLGenerationCommand;
import org.contextmapper.dsl.ide.commands.impl.generation.NewServiceCutGenerationCommand;
import org.contextmapper.dsl.ide.commands.impl.generation.PlantUMLGenerationCommand;
import org.contextmapper.dsl.ide.commands.impl.generation.ServiceCutterInputGenerationCommand;
import org.contextmapper.dsl.ide.commands.impl.generation.ServiceCutterUserRepresentationExampleFileGenerationCommand;
import org.contextmapper.dsl.ide.commands.impl.generation.ServiceCutterUserRepresentationsGenerationCommand;
import org.contextmapper.dsl.ide.commands.impl.generation.SketchMinerGenerationCommand;
import org.contextmapper.dsl.ide.commands.impl.quickfix.SplitStoryByVerbCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.DeriveBoundedContextFromSubdomainsCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.DeriveFrontendAndBackendFromFeatureBCCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.DeriveSubdomainFromUserRequirementsCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.ExtractAggregatesByCohesionCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.ExtractAggregatesByVolatilityCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.ExtractSharedKernelCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.ExtractSuggestedServiceCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.MergeAggregatesCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.MergeBoundedContextsCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.SplitAggregateByEntitiesRefactoringCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.SplitBoundedContextByFeaturesRefactoringCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.SplitBoundedContextByOwnerRefactoringCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.SplitSystemContextIntoSubsystemsCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.SuspendPartnershipCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.SwitchFromPartnershipToSharedKernelCommand;
import org.contextmapper.dsl.ide.commands.impl.refactoring.SwitchFromSharedKernelToPartnershipCommand;
import org.contextmapper.dsl.ide.edit.WorkspaceEditRecorder;

public class CMLCommandRegistry {
    private Map<String, CMLResourceCommand> commandMap = Maps.newHashMap();
    private WorkspaceEditRecorder editRecorder;

    @Inject
    public CMLCommandRegistry(WorkspaceEditRecorder editRecorder) {
        this.editRecorder = editRecorder;
        this.registerCommands();
    }

    private void registerCommands() {
        this.commandMap.put("cml.generate.contextmap", new ContextMapGenerationCommand());
        this.commandMap.put("cml.generate.puml", new PlantUMLGenerationCommand());
        this.commandMap.put("cml.generate.sketchminer", new SketchMinerGenerationCommand());
        this.commandMap.put("cml.generate.mdsl", new MDSLGenerationCommand());
        this.commandMap.put("cml.generate.generic.text.file", new GenericTextFileGenerationCommand());
        this.commandMap.put("cml.generate.new.service.cut", new NewServiceCutGenerationCommand());
        this.commandMap.put("cml.generate.servicecutter.input", new ServiceCutterInputGenerationCommand());
        this.commandMap.put("cml.generate.servicecutter.user.representations", new ServiceCutterUserRepresentationsGenerationCommand());
        this.commandMap.put("cml.generate.servicecutter.user.representation.example.file", new ServiceCutterUserRepresentationExampleFileGenerationCommand());
        this.commandMap.put("cml.ar.splitBCByOwner", new SplitBoundedContextByOwnerRefactoringCommand(this.editRecorder));
        this.commandMap.put("cml.ar.splitBCByFeature", new SplitBoundedContextByFeaturesRefactoringCommand(this.editRecorder));
        this.commandMap.put("cml.ar.splitAggregateByEntities", new SplitAggregateByEntitiesRefactoringCommand(this.editRecorder));
        this.commandMap.put("cml.ar.deriveSubdomainFromURs", new DeriveSubdomainFromUserRequirementsCommand(this.editRecorder));
        this.commandMap.put("cml.ar.deriveBoundedContextFromSDs", new DeriveBoundedContextFromSubdomainsCommand(this.editRecorder));
        this.commandMap.put("cml.ar.deriveFrontendBackendSystemsFromFeatureBC", new DeriveFrontendAndBackendFromFeatureBCCommand(this.editRecorder));
        this.commandMap.put("cml.ar.splitSystemContextIntoSubsystems", new SplitSystemContextIntoSubsystemsCommand(this.editRecorder));
        this.commandMap.put("cml.ar.extractAggregatesByVolatility", new ExtractAggregatesByVolatilityCommand(this.editRecorder));
        this.commandMap.put("cml.ar.extractAggregatesByCohesion", new ExtractAggregatesByCohesionCommand(this.editRecorder));
        this.commandMap.put("cml.ar.mergeAggregates", new MergeAggregatesCommand(this.editRecorder));
        this.commandMap.put("cml.ar.mergeBoundedContexts", new MergeBoundedContextsCommand(this.editRecorder));
        this.commandMap.put("cml.ar.extractSharedKernel", new ExtractSharedKernelCommand(this.editRecorder));
        this.commandMap.put("cml.ar.suspendPartnership", new SuspendPartnershipCommand(this.editRecorder));
        this.commandMap.put("cml.ar.switchPartnershipToSharedKernel", new SwitchFromPartnershipToSharedKernelCommand(this.editRecorder));
        this.commandMap.put("cml.ar.switchSharedKernelToPartnership", new SwitchFromSharedKernelToPartnershipCommand(this.editRecorder));
        this.commandMap.put("cml.ar.extractSuggestedService", new ExtractSuggestedServiceCommand(this.editRecorder));
        this.commandMap.put("cml.quickfix.command.splitStoryByVerb", new SplitStoryByVerbCommand(this.editRecorder));
    }

    public CMLResourceCommand getCommand(String commandId) {
        return this.commandMap.get(commandId);
    }

    public Set<String> getCommandIds() {
        return Sets.newHashSet(this.commandMap.keySet());
    }
}

