/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.commands.impl.refactoring;

import com.google.gson.JsonArray;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.ide.commands.impl.refactoring.AbstractRefactoringCommand;
import org.contextmapper.dsl.ide.edit.WorkspaceEditRecorder;
import org.contextmapper.dsl.refactoring.ExtractSuggestedService;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;

public class ExtractSuggestedServiceCommand
extends AbstractRefactoringCommand {
    private CMLResource cmlResource;

    public ExtractSuggestedServiceCommand(WorkspaceEditRecorder editRecorder) {
        super(editRecorder);
    }

    @Override
    public void executeCommand(CMLResource cmlResource, Document document, ILanguageServerAccess access, ExecuteCommandParams params) {
        this.cmlResource = cmlResource;
        super.executeCommand(cmlResource, document, access, params);
    }

    @Override
    protected SemanticCMLRefactoring getRefactoring(ExecuteCommandParams params) {
        JsonArray refactoringParams = (JsonArray)params.getArguments().get(1);
        JsonPrimitive serviceCutResourceURI = (JsonPrimitive)refactoringParams.get(0);
        JsonPrimitive serviceToExtractName = (JsonPrimitive)refactoringParams.get(1);
        JsonPrimitive newBoundedContextName = (JsonPrimitive)refactoringParams.get(2);
        URI serviceCutURI = URI.createURI((String)serviceCutResourceURI.getAsString());
        CMLResource serviceCutResource = new CMLResource(this.cmlResource.getResourceSet().getResource(serviceCutURI, true));
        Optional<BoundedContext> serviceToExtract = serviceCutResource.getContextMappingModel().getBoundedContexts().stream().filter(bc -> bc.getName().equals(serviceToExtractName.getAsString())).findFirst();
        if (!serviceToExtract.isPresent()) {
            throw new ContextMapperApplicationException("A service with the name '" + serviceToExtractName.getAsString() + "' does not exist in the CML model '" + serviceCutResourceURI.getAsString() + "'.");
        }
        return new ExtractSuggestedService(serviceToExtract.get(), newBoundedContextName.getAsString());
    }
}

