/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.quickfix.impl;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.Feature;
import org.contextmapper.dsl.contextMappingDSL.UserStory;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.ide.quickfix.QuickfixCommandMapper;
import org.contextmapper.dsl.quickfixes.CMLQuickFix;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;

public class SplitStoryByVerbCommandMapper
implements QuickfixCommandMapper {
    private CMLQuickFix<? extends EObject> quickFix;

    public SplitStoryByVerbCommandMapper(CMLQuickFix<? extends EObject> quickFix) {
        this.quickFix = quickFix;
    }

    @Override
    public CodeAction getCodeAction(CMLResource cmlResource, EObject selectedObject) {
        if (!(selectedObject instanceof Feature)) {
            throw new ContextMapperApplicationException("Mapping exception: this quickfix was mapped to an object that is not of the type 'Feature'.");
        }
        UserStory story = this.getSelectedStory((Feature)selectedObject);
        CodeAction codeAction = new CodeAction(this.quickFix.getName());
        codeAction.setKind("quickfix");
        Command command = new Command(this.quickFix.getName(), "cml.quickfix.command.splitStoryByVerb.proxy");
        command.setArguments((List)Lists.newLinkedList(Arrays.asList(cmlResource.getURI().toString(), story.getName())));
        codeAction.setCommand(command);
        return codeAction;
    }

    private UserStory getSelectedStory(Feature feature) {
        if (!(feature.eContainer() instanceof UserStory)) {
            throw new ContextMapperApplicationException("Quick fix mapping exception: this quickfix can only be applied on User Stories.");
        }
        return (UserStory)feature.eContainer();
    }
}

