/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.servicecutter.dsl.ide.commands;

import com.google.common.collect.Lists;
import com.google.gson.JsonPrimitive;
import com.google.inject.Inject;
import java.util.List;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.contextmapper.servicecutter.dsl.ide.commands.SCLCommandRegistry;
import org.contextmapper.servicecutter.dsl.ide.commands.SCLResourceCommand;
import org.contextmapper.servicecutter.dsl.scl.SCLResourceContainer;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.commands.IExecutableCommandService;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class SCLCommandService
implements IExecutableCommandService {
    private static final Logger LOG = Logger.getLogger(SCLCommandService.class);
    public static final String COMMAND_EXECUTED_RETURN_VALUE = "Command executed.";
    public static final String COMMAND_EXECUTION_ERROR_PREFIX = "Error occurred:";
    @Inject
    private SCLCommandRegistry commandRegistry;

    public List<String> initialize() {
        return Lists.newLinkedList(this.commandRegistry.getCommandIds());
    }

    public Object execute(ExecuteCommandParams params, ILanguageServerAccess access, CancelIndicator cancelIndicator) {
        try {
            SCLResourceCommand command = this.commandRegistry.getCommand(params.getCommand());
            if (command == null) {
                return "Unknown command ID!";
            }
            Object _head = IterableExtensions.head((Iterable)params.getArguments());
            JsonPrimitive uri = (JsonPrimitive)_head;
            if (uri != null) {
                Function<ILanguageServerAccess.Context, String> _function = it -> {
                    String _command = params.getCommand();
                    String _plus = "SCL LSP command has been called: " + _command;
                    String _plus_1 = _plus + " (";
                    Object _get = params.getArguments().get(0);
                    String _plus_2 = _plus_1 + _get;
                    String _plus_3 = _plus_2 + ")";
                    LOG.info((Object)_plus_3);
                    try {
                        Resource _resource = it.getResource();
                        SCLResourceContainer _sCLResourceContainer = new SCLResourceContainer(_resource);
                        command.executeCommand(_sCLResourceContainer, it.getDocument(), access, params);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            Exception e = (Exception)_t;
                            LOG.error((Object)("The command '" + command + "' resulted in an error"), (Throwable)e);
                            e.printStackTrace(System.out);
                            String _message = e.getMessage();
                            return "Error occurred: " + _message;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                    return COMMAND_EXECUTED_RETURN_VALUE;
                };
                return access.doRead(uri.getAsString(), _function).get();
            }
            return "Error occurred: No resource URI found in command arguments!";
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

