/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.interpreter.impl;

import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.interpreter.Assignment;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Match;
import org.eclipse.emf.henshin.interpreter.RuleApplication;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.BasicApplicationMonitor;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class LoggingApplicationMonitor
extends BasicApplicationMonitor {
    protected PrintStream logStream = System.out;
    protected boolean onlyRuleApplications = false;
    protected boolean onlyUnitApplications = false;
    protected boolean onlySuccesses = false;
    protected boolean onlyFailures = false;
    protected URI autoSaveURI;
    protected int step = 0;
    protected int maxSteps = -1;

    @Override
    public void cancel() {
        super.cancel();
        if (this.logStream != null) {
            this.logStream.println("=== CANCEL REQUESTED ===\n");
        }
    }

    @Override
    public void cancelAndUndo() {
        super.cancelAndUndo();
        if (this.logStream != null) {
            this.logStream.println("=== CANCEL AND UNDO REQUESTED ===\n");
        }
    }

    @Override
    public void notifyExecute(UnitApplication application, boolean success) {
        super.notifyExecute(application, success);
        this.logStep(application, success, "EXECUTED");
    }

    @Override
    public void notifyUndo(UnitApplication application, boolean success) {
        super.notifyUndo(application, success);
        this.logStep(application, success, "UNDONE");
    }

    @Override
    public void notifyRedo(UnitApplication application, boolean success) {
        super.notifyExecute(application, success);
        this.logStep(application, success, "REDONE");
    }

    protected void logStep(UnitApplication application, boolean success, String stepKind) {
        if (this.logStream == null) {
            return;
        }
        if (this.onlyRuleApplications && !(application instanceof RuleApplication)) {
            return;
        }
        if (this.onlyUnitApplications && application instanceof RuleApplication) {
            return;
        }
        if (this.onlySuccesses && !success) {
            return;
        }
        if (this.onlyFailures && success) {
            return;
        }
        ++this.step;
        EGraph graph = application.getEGraph();
        this.logStream.println("=== (" + this.step + ") " + stepKind + (application instanceof RuleApplication ? " RULE " : " UNIT ") + "'" + application.getUnit().getName() + "' [" + String.valueOf(success).toUpperCase() + "] ===\n");
        String edges = "?";
        try {
            edges = String.valueOf(InterpreterUtil.countEdges(graph));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.logStream.println("Graph size: " + graph.size() + " nodes, " + edges + " edges\n");
        if (application instanceof RuleApplication) {
            RuleApplication ruleApp = (RuleApplication)application;
            if (success) {
                this.logStream.println(ruleApp.getCompleteMatch());
                this.logStream.println(ruleApp.getResultMatch());
            } else {
                Match match = ruleApp.getPartialMatch();
                if (match != null && !match.isEmpty()) {
                    this.logStream.println("Partial " + ruleApp.getPartialMatch().toString().replaceFirst("Match", "match"));
                }
            }
        } else {
            Assignment assignment = application.getAssignment();
            Assignment resultAssignment = application.getResultAssignment();
            if (assignment != null && !assignment.isEmpty()) {
                this.logStream.println(assignment);
            }
            if (success && resultAssignment != null && !resultAssignment.isEmpty()) {
                this.logStream.println(resultAssignment);
            }
        }
        if (this.autoSaveURI != null) {
            String basename = this.autoSaveURI.lastSegment();
            String realname = this.autoSaveURI.trimFileExtension().lastSegment() + "-" + new DecimalFormat("0000").format(this.step) + "." + this.autoSaveURI.fileExtension();
            URI uri = URI.createURI((String)this.autoSaveURI.toString().replaceFirst(basename, realname));
            HenshinResourceSet resourceSet = null;
            for (EObject root : graph.getRoots()) {
                if (root.eResource() == null || root.eResource().getResourceSet() == null) continue;
                resourceSet = root.eResource().getResourceSet();
                break;
            }
            if (resourceSet == null) {
                resourceSet = new HenshinResourceSet();
            }
            EGraph copy = graph.copy(null);
            Resource resource = resourceSet.createResource(uri);
            resource.getContents().addAll(copy.getRoots());
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("SCHEMA_LOCATION", Boolean.TRUE);
            try {
                System.out.println("Saving intermediate result to " + uri + "\n");
                resource.save(options);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.maxSteps >= 0 && this.step >= this.maxSteps) {
            System.out.println("Terminated after " + this.step + " steps by logging application monitor.");
            System.exit(1);
        }
    }

    public void setLogStream(PrintStream logStream) {
        this.logStream = logStream;
    }

    public void setOnlyRuleApplications(boolean onlyRuleApplications) {
        this.onlyRuleApplications = onlyRuleApplications;
    }

    public void setOnlyUnitApplications(boolean onlyUnitApplications) {
        this.onlyUnitApplications = onlyUnitApplications;
    }

    public void setOnlySuccesses(boolean onlySuccesses) {
        this.onlySuccesses = onlySuccesses;
    }

    public void setOnlyFailures(boolean onlyFailures) {
        this.onlyFailures = onlyFailures;
    }

    public void setAutoSaveURI(URI autoSaveURI) {
        this.autoSaveURI = autoSaveURI;
    }

    public void setMaxSteps(int maxSteps) {
        this.maxSteps = maxSteps;
    }
}

