/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.actions;

import java.util.List;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.actions.EdgeMapEditor;
import org.eclipse.emf.henshin.model.actions.NodeMapEditor;

public class MultiRuleMapEditor {
    private final Rule kernel;
    private final Rule multi;
    private final NodeMapEditor lhsNodeMapEditor;
    private final NodeMapEditor rhsNodeMapEditor;
    private final EdgeMapEditor lhsEdgeMapEditor;
    private final EdgeMapEditor rhsEdgeMapEditor;

    public MultiRuleMapEditor(Rule kernel, Rule multi) {
        this.kernel = kernel;
        this.multi = multi;
        this.lhsNodeMapEditor = new NodeMapEditor(kernel.getLhs(), multi.getLhs(), multi.getMultiMappings());
        this.lhsEdgeMapEditor = new EdgeMapEditor(kernel.getLhs(), multi.getLhs(), multi.getMultiMappings());
        this.rhsNodeMapEditor = new NodeMapEditor(kernel.getRhs(), multi.getRhs(), multi.getMultiMappings());
        this.rhsEdgeMapEditor = new EdgeMapEditor(kernel.getRhs(), multi.getRhs(), multi.getMultiMappings());
    }

    public void moveMappedNode(Node node) {
        Node opposite = this.getOppositeNode(node);
        Graph graph = node.getGraph();
        if (opposite == null || graph == null) {
            return;
        }
        if (graph.getRule() == this.kernel) {
            this.multi.getMappings().add(this.getHorizontalMapping(node, opposite));
        } else if (graph.getRule() == this.multi) {
            this.kernel.getMappings().add(this.getHorizontalMapping(node, opposite));
        }
        if (graph == this.kernel.getLhs() || graph == this.multi.getLhs()) {
            this.rhsNodeMapEditor.move(opposite);
            this.lhsNodeMapEditor.move(node);
        } else if (graph == this.kernel.getRhs() || graph == this.multi.getRhs()) {
            this.rhsNodeMapEditor.move(node);
            this.lhsNodeMapEditor.move(opposite);
        }
        MultiRuleMapEditor.removeInvalidMappings((List<Mapping>)((Object)this.multi.getMappings()), this.multi.getLhs(), this.multi.getRhs());
    }

    private static void removeInvalidMappings(List<Mapping> mappings, Graph source, Graph target) {
        for (int i = 0; i < mappings.size(); ++i) {
            Mapping mapping = mappings.get(i);
            if (mapping.getOrigin().getGraph() == source && mapping.getImage().getGraph() == target) continue;
            mappings.remove(i--);
        }
    }

    public void copyMappedNode(Node node) {
        Node copiedNode;
        Node copiedOpposite;
        Node opposite = this.getOppositeNode(node);
        Graph graph = node.getGraph();
        if (opposite == null || graph == null) {
            return;
        }
        if (graph == this.kernel.getLhs() || graph == this.multi.getLhs()) {
            copiedOpposite = this.rhsNodeMapEditor.copy(opposite);
            copiedNode = this.lhsNodeMapEditor.copy(node);
        } else if (graph == this.kernel.getRhs() || graph == this.multi.getRhs()) {
            copiedNode = this.rhsNodeMapEditor.copy(node);
            copiedOpposite = this.lhsNodeMapEditor.copy(opposite);
        } else {
            return;
        }
        Mapping mapping = this.getHorizontalMapping(node, opposite);
        if (graph.getRule() == this.kernel) {
            this.copyMapping(mapping, node, opposite, copiedNode, copiedOpposite, this.multi);
        } else if (graph.getRule() == this.multi) {
            this.copyMapping(mapping, node, opposite, copiedNode, copiedOpposite, this.kernel);
        }
    }

    public void moveMappedEdge(Edge edge) {
        Rule from;
        Edge opposite = this.getOppositeEdge(edge);
        Graph graph = edge.getGraph();
        if (opposite == null || graph == null) {
            return;
        }
        if (graph == this.kernel.getLhs() || graph == this.kernel.getRhs()) {
            from = this.kernel;
        } else if (graph == this.multi.getLhs() || graph == this.multi.getRhs()) {
            from = this.multi;
        } else {
            return;
        }
        this.copyMappedNode(edge.getSource());
        this.copyMappedNode(edge.getTarget());
        if (graph == from.getLhs()) {
            this.lhsEdgeMapEditor.move(edge);
            this.rhsEdgeMapEditor.move(opposite);
        } else if (graph == from.getRhs()) {
            this.lhsEdgeMapEditor.move(opposite);
            this.rhsEdgeMapEditor.move(edge);
        }
    }

    public void moveMappedElement(Object element) {
        if (element instanceof Node) {
            this.moveMappedNode((Node)element);
        } else if (element instanceof Edge) {
            this.moveMappedEdge((Edge)element);
        }
    }

    public void ensureCompleteness() {
        for (Node node : this.kernel.getLhs().getNodes()) {
            this.copyNodeToTarget(node);
        }
        for (Edge edge : this.kernel.getLhs().getEdges()) {
            this.copyEdgeToTarget(edge);
        }
    }

    private void copyNodeToTarget(Node node) {
        if (this.getOppositeNode(node) != null) {
            this.copyMappedNode(node);
        } else if (node.getGraph() == this.kernel.getLhs()) {
            this.lhsNodeMapEditor.copy(node);
        } else if (node.getGraph() == this.kernel.getRhs()) {
            this.rhsNodeMapEditor.copy(node);
        }
    }

    private void copyEdgeToTarget(Edge edge) {
        Edge opposite = this.getOppositeEdge(edge);
        if (edge.getGraph() == this.kernel.getLhs()) {
            this.lhsEdgeMapEditor.copy(edge);
            if (opposite != null) {
                this.rhsEdgeMapEditor.copy(opposite);
            }
        } else if (edge.getGraph() == this.kernel.getRhs()) {
            this.rhsEdgeMapEditor.copy(edge);
            if (opposite != null) {
                this.lhsEdgeMapEditor.copy(opposite);
            }
        }
    }

    private Node getOppositeNode(Node node) {
        if (node.getGraph().getRule() == this.kernel) {
            return new NodeMapEditor(this.kernel.getRhs()).getOpposite(node);
        }
        if (node.getGraph().getRule() == this.multi) {
            return new NodeMapEditor(this.multi.getRhs()).getOpposite(node);
        }
        return null;
    }

    private Edge getOppositeEdge(Edge edge) {
        if (edge.getGraph().getRule() == this.kernel) {
            return new EdgeMapEditor(this.kernel.getRhs()).getOpposite(edge);
        }
        if (edge.getGraph().getRule() == this.multi) {
            return new EdgeMapEditor(this.multi.getRhs()).getOpposite(edge);
        }
        return null;
    }

    private Mapping getHorizontalMapping(Node n1, Node n2) {
        Mapping mapping = this.kernel.getMappings().get(n1, n2);
        if (mapping == null) {
            mapping = this.multi.getMappings().get(n1, n2);
        }
        return mapping;
    }

    private void copyMapping(Mapping mapping, Node old1, Node old2, Node new1, Node new2, Rule rule) {
        if (mapping.getOrigin() == old1 && mapping.getImage() == old2) {
            rule.getMappings().add(new1, new2);
        } else if (mapping.getOrigin() == old2 && mapping.getImage() == old1) {
            rule.getMappings().add(new2, new1);
        }
    }
}

