/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptEngineWrapper {
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("(.*)\\.\\*$");
    private final ScriptEngine engine;
    private final List<String> globalImports;

    public ScriptEngineWrapper(ScriptEngine engine, String[] globalImports) {
        this.engine = engine;
        this.globalImports = new ArrayList<String>();
        if (globalImports != null) {
            for (int i = 0; i < globalImports.length; ++i) {
                this.globalImports.add(globalImports[i]);
            }
        }
        if (engine == null) {
            System.err.println("Warning: cannot find JavaScript engine");
        }
    }

    public ScriptEngineWrapper(String[] globalImports) {
        this(new ScriptEngineManager().getEngineByName("JavaScript"), globalImports);
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }

    public Object eval(String script, List<String> localImports) throws ScriptException {
        if (!this.globalImports.isEmpty() || !localImports.isEmpty()) {
            script = "with (new JavaImporter(" + ScriptEngineWrapper.toImportString(this.globalImports, localImports) + ")) { " + script + " }";
        }
        return this.engine.eval(script);
    }

    private static String toImportString(List<String> ... imports) {
        StringBuffer out = new StringBuffer();
        String delim = "";
        for (int i = 0; i < imports.length; ++i) {
            for (String entry : imports[i]) {
                out.append(delim).append(ScriptEngineWrapper.stripWildcard(entry));
                delim = ", ";
            }
        }
        return out.toString();
    }

    private static String stripWildcard(String imp) {
        return ScriptEngineWrapper.isWildcard(imp) ? imp.substring(0, imp.length() - 2) : imp;
    }

    private static boolean isWildcard(String imp) {
        return WILDCARD_PATTERN.matcher(imp).matches();
    }
}

