/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.cml;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Import;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class CMLImportResolver {
    public Set<CMLResource> resolveImportedResources(CMLResource rootResource) {
        HashSet importedResources = Sets.newHashSet();
        CMLResource resource = rootResource;
        ResourceSet rs = resource.getResourceSet();
        ContextMappingModel cmlModel = (ContextMappingModel)resource.getContents().get(0);
        for (Import cmlImport : cmlModel.getImports()) {
            URI importURI = URI.createURI((String)cmlImport.getImportURI()).resolve(resource.getURI());
            Resource importedResource = rs.getResource(importURI, true);
            if (!this.isResourceCMLModel(importedResource)) continue;
            importedResources.add(new CMLResource(importedResource));
        }
        return importedResources;
    }

    private boolean isResourceCMLModel(Resource resource) {
        if (resource.getContents().isEmpty()) {
            return false;
        }
        return resource.getContents().get(0) instanceof ContextMappingModel;
    }
}

