/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Flow;
import org.contextmapper.dsl.generator.AbstractContextMappingModelGenerator;
import org.contextmapper.dsl.generator.exception.GeneratorInputException;
import org.contextmapper.dsl.generator.sketchminer.SketchMinerModelCreator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class SketchMinerGenerator
extends AbstractContextMappingModelGenerator {
    private static final String SKETCH_MINER_FILE_EXT = "sketch_miner";

    @Override
    protected void generateFromContextMappingModel(ContextMappingModel model, IFileSystemAccess2 fsa, URI inputFileURI) {
        this.checkPreconditions();
        String fileName = inputFileURI.trimFileExtension().lastSegment();
        for (BoundedContext boundedContext : model.getBoundedContexts()) {
            for (Flow flow : this.getFlowsWithSteps(boundedContext)) {
                fsa.generateFile(fileName + "_BC_" + boundedContext.getName() + "_" + flow.getName() + "." + SKETCH_MINER_FILE_EXT, (CharSequence)new SketchMinerModelCreator().createText(flow));
            }
        }
    }

    private void checkPreconditions() {
        for (BoundedContext boundedContext : this.contextMappingModel.getBoundedContexts()) {
            Set nonEmptyFlows;
            if (boundedContext.getApplication() == null || boundedContext.getApplication().getFlows() == null || (nonEmptyFlows = boundedContext.getApplication().getFlows().stream().filter(f -> !f.getSteps().isEmpty()).collect(Collectors.toSet())).isEmpty()) continue;
            return;
        }
        throw new GeneratorInputException("Your model does not contain any Bounded Contexts with application layer and flow definition.");
    }

    private Set<Flow> getFlowsWithSteps(BoundedContext boundedContext) {
        if (boundedContext.getApplication() == null || boundedContext.getApplication().getFlows() == null) {
            return Sets.newHashSet();
        }
        return boundedContext.getApplication().getFlows().stream().filter(f -> !f.getSteps().isEmpty()).collect(Collectors.toSet());
    }
}

