/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.contextmapper.dsl.generator.plantuml.AbstractPlantUMLDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.ClassRelationType;
import org.contextmapper.dsl.generator.plantuml.UMLRelationship;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.CollectionType;
import org.contextmapper.tactic.dsl.tacticdsl.CommandEvent;
import org.contextmapper.tactic.dsl.tacticdsl.ComplexType;
import org.contextmapper.tactic.dsl.tacticdsl.DomainEvent;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObjectOperation;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.Enum;
import org.contextmapper.tactic.dsl.tacticdsl.EnumValue;
import org.contextmapper.tactic.dsl.tacticdsl.Event;
import org.contextmapper.tactic.dsl.tacticdsl.Parameter;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.ValueObject;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractPlantUMLClassDiagramCreator<T extends EObject>
extends AbstractPlantUMLDiagramCreator<T> {
    protected List<UMLRelationship> relationships;
    protected List<UMLRelationship> extensions;
    protected List<SimpleDomainObject> domainObjects;

    protected void printDomainObject(SimpleDomainObject domainObject, int indentation) {
        if (domainObject instanceof Enum) {
            this.printEnum((Enum)domainObject, indentation);
        } else if (domainObject instanceof Entity) {
            this.printEntity((Entity)domainObject, indentation);
        } else if (domainObject instanceof Event) {
            this.printEvent((Event)domainObject, indentation);
        } else if (domainObject instanceof ValueObject) {
            this.printValueObject((ValueObject)domainObject, indentation);
        }
    }

    private void printEnum(Enum theEnum, int indentation) {
        this.printIndentation(indentation);
        this.sb.append("enum").append(" ").append(theEnum.getName()).append(" {");
        this.linebreak();
        for (EnumValue value : theEnum.getValues()) {
            this.printIndentation(indentation + 1);
            this.sb.append(value.getName());
            this.linebreak();
        }
        this.printIndentation(indentation);
        this.sb.append("}");
        this.linebreak();
    }

    private void printEntity(Entity entity, int indentation) {
        this.printStereotypedClass("(E,DarkSeaGreen) Entity", entity, indentation);
    }

    private void printValueObject(ValueObject valueObject, int indentation) {
        this.printStereotypedClass("(V,DarkSeaGreen) Value Object", valueObject, indentation);
    }

    private void printEvent(Event event, int indentation) {
        if (event instanceof CommandEvent) {
            this.printStereotypedClass("(C,#3bc5e9) Command", event, indentation);
        } else if (event instanceof DomainEvent) {
            this.printStereotypedClass("(E,#ff9f4b) Domain Event", event, indentation);
        }
    }

    private void printStereotypedClass(String stereotype, DomainObject object, int indentation) {
        this.printIndentation(indentation);
        this.sb.append("class").append(" ").append(object.getName());
        if (object.isAggregateRoot()) {
            this.sb.append(" <<(A,#fffab8) Aggregate Root>> ");
        } else {
            this.sb.append(" <<" + stereotype + ">> ");
        }
        this.sb.append("{");
        this.linebreak();
        this.printAttributes((List<Attribute>)object.getAttributes(), indentation + 1);
        this.printReferenceAttributes((List<Reference>)object.getReferences(), indentation + 1);
        this.addReferences2List(object, (List<Reference>)object.getReferences());
        this.printDomainObjectOperations(object.getName(), (List<DomainObjectOperation>)object.getOperations(), indentation + 1);
        this.printIndentation(indentation);
        this.sb.append("}");
        this.linebreak();
        if (object.getExtendsName() != null && !"".equals(object.getExtendsName())) {
            this.addExtensionToList(object.getName(), object.getExtendsName());
        } else if (object instanceof Entity && ((Entity)object).getExtends() != null) {
            this.addExtensionToList(object.getName(), ((Entity)object).getExtends());
        } else if (object instanceof CommandEvent && ((CommandEvent)object).getExtends() != null) {
            this.addExtensionToList(object.getName(), ((CommandEvent)object).getExtends());
        } else if (object instanceof DomainEvent && ((DomainEvent)object).getExtends() != null) {
            this.addExtensionToList(object.getName(), ((DomainEvent)object).getExtends());
        } else if (object instanceof ValueObject && ((ValueObject)object).getExtends() != null) {
            this.addExtensionToList(object.getName(), ((ValueObject)object).getExtends());
        }
    }

    private void addReferences2List(SimpleDomainObject sourceDomainObject, List<Reference> references) {
        for (Reference reference : references) {
            if (reference.getCollectionType() != null && reference.getCollectionType() != CollectionType.NONE) {
                this.addDomainObjectReference2List(sourceDomainObject.getName(), reference.getDomainObjectType(), reference.getName(), ClassRelationType.AGGREGATION);
                continue;
            }
            this.addDomainObjectReference2List(sourceDomainObject.getName(), reference.getDomainObjectType(), reference.getName(), ClassRelationType.DEFAULT);
        }
    }

    private void addDomainObjectReference2List(String sourceDomainObject, SimpleDomainObject targetDomainObject, String label, ClassRelationType type) {
        UMLRelationship relationship;
        if (this.domainObjects.contains(targetDomainObject) && !this.relationships.contains(relationship = new UMLRelationship(sourceDomainObject, targetDomainObject.getName(), label, type))) {
            this.relationships.add(relationship);
        }
    }

    private void addExtensionToList(String sourceDomainObject, SimpleDomainObject extendedDomainObject) {
        if (this.domainObjects.contains(extendedDomainObject)) {
            this.addExtensionToList(sourceDomainObject, extendedDomainObject.getName());
        }
    }

    private void addExtensionToList(String sourceDomainObject, String extendedDomainObject) {
        UMLRelationship relationship = new UMLRelationship(sourceDomainObject, extendedDomainObject, "", ClassRelationType.EXTENSION);
        if (!this.extensions.contains(relationship)) {
            this.extensions.add(relationship);
        }
    }

    private void printAttributes(List<Attribute> attributes, int indentation) {
        for (Attribute attribute : attributes) {
            this.printIndentation(indentation);
            this.sb.append(this.getAttributeTypeAsString(attribute));
            this.sb.append(" ").append(attribute.getName());
            this.linebreak();
        }
    }

    private void printDomainObjectOperations(String objectName, List<DomainObjectOperation> operations, int indentation) {
        for (DomainObjectOperation operation : operations) {
            this.printOperation(objectName, operation.getName(), operation.getReturnType(), (List<Parameter>)operation.getParameters(), indentation);
        }
    }

    private String getAttributeTypeAsString(Attribute attribute) {
        String type = attribute.getType();
        if (attribute.getCollectionType() != CollectionType.NONE) {
            type = (Object)((Object)attribute.getCollectionType()) + "<" + attribute.getType() + ">";
        }
        if (attribute.isNullable()) {
            type = type + "[0..1]";
        }
        return type;
    }

    private void printReferenceAttributes(List<Reference> references, int indentation) {
        for (Reference reference : references) {
            this.printIndentation(indentation);
            this.sb.append(this.getReferenceTypeAsString(reference));
            if (reference.isNullable()) {
                this.sb.append("[0..1]");
            }
            this.sb.append(" ").append(reference.getName());
            this.linebreak();
        }
    }

    protected void printOperation(String objectName, String operationName, ComplexType returnType, List<Parameter> parameters, int indentation) {
        this.printIndentation(indentation);
        String returnTypeAsString = returnType == null ? "void" : this.getComplexMethodTypeAsString(returnType, objectName, operationName);
        this.sb.append(returnTypeAsString).append(" ").append(operationName).append("(");
        ArrayList parameterStrings = Lists.newArrayList();
        for (Parameter parameter : parameters) {
            String parameterType = this.getComplexMethodTypeAsString(parameter.getParameterType(), objectName, operationName);
            parameterStrings.add(parameterType + " " + parameter.getName());
        }
        if (!parameterStrings.isEmpty()) {
            this.sb.append(String.join((CharSequence)", ", parameterStrings));
        }
        this.sb.append(")");
        this.linebreak();
    }

    private String getComplexMethodTypeAsString(ComplexType type, String containingObjectName4References, String methodName) {
        String genericType = "Object";
        if (type.getDomainObjectType() != null) {
            genericType = type.getDomainObjectType().getName();
            this.addDomainObjectReference2List(containingObjectName4References, type.getDomainObjectType(), methodName, ClassRelationType.DEFAULT);
        } else {
            genericType = type.getType();
        }
        if (type.getCollectionType() != CollectionType.NONE) {
            return type.getCollectionType().getName() + "<" + genericType + ">";
        }
        return genericType;
    }

    private String getReferenceTypeAsString(Reference reference) {
        if (reference.getCollectionType() != CollectionType.NONE) {
            return reference.getCollectionType().getName() + "<" + reference.getDomainObjectType().getName() + ">";
        }
        return reference.getDomainObjectType().getName();
    }

    protected void printReferences(int indentation) {
        for (UMLRelationship reference : this.relationships) {
            this.printIndentation(indentation);
            this.sb.append(reference.getSource()).append(" ").append(reference.getSymbol()).append(" ").append(reference.getTarget());
            if (!"".equals(reference.getLabel())) {
                this.sb.append(" : ").append(reference.getLabel());
            }
            this.linebreak();
        }
        for (UMLRelationship extension : this.extensions) {
            this.printIndentation(indentation);
            this.sb.append(extension.getSource()).append(" ").append(extension.getSymbol()).append(" ").append(extension.getTarget());
            this.linebreak();
        }
    }

    protected void printIndentation(int amount) {
        for (int i = 0; i < amount; ++i) {
            this.sb.append("\t");
        }
    }
}

