/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.generator.plantuml.AbstractPlantUMLDiagramCreator;
import org.contextmapper.tactic.dsl.tacticdsl.EnumValue;
import org.contextmapper.tactic.dsl.tacticdsl.StateTransition;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractPlantUMLStateDiagramCreator<T extends EObject>
extends AbstractPlantUMLDiagramCreator<T> {
    protected void printState(String state) {
        this.sb.append(state + " : ");
        this.linebreak();
    }

    protected void printTransition(StateTransition transition, String label) {
        if (transition.getFrom() == null || transition.getFrom().isEmpty()) {
            for (String target : this.mapStatesToStrings(transition.getTarget().getTo().stream().map(s -> s.getValue()).collect(Collectors.toList()))) {
                this.sb.append("[*] --> ").append(target).append(" : ").append(label);
                this.linebreak();
            }
        }
        for (String from : transition.getFrom().stream().map(s -> s.getName()).collect(Collectors.toSet())) {
            for (String target : this.mapStatesToStrings(transition.getTarget().getTo().stream().map(s -> s.getValue()).collect(Collectors.toList()))) {
                this.sb.append(from).append(" --> ").append(target).append(" : ").append(label);
                this.linebreak();
            }
        }
    }

    protected Set<String> collectStates(List<StateTransition> transitions) {
        HashSet states = Sets.newHashSet();
        for (StateTransition transition : transitions) {
            states.addAll(this.mapStatesToStrings((List<EnumValue>)transition.getFrom()));
            states.addAll(this.mapStatesToStrings(transition.getTarget().getTo().stream().map(s -> s.getValue()).collect(Collectors.toList())));
        }
        return states;
    }

    private Set<String> mapStatesToStrings(List<EnumValue> states) {
        if (states != null && !states.isEmpty()) {
            return states.stream().map(s -> s.getName()).collect(Collectors.toSet());
        }
        return Sets.newHashSet();
    }
}

