/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.plantuml;

import com.google.common.collect.Lists;
import org.contextmapper.dsl.contextMappingDSL.SubDomainType;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.generator.plantuml.AbstractPlantUMLClassDiagramCreator;
import org.contextmapper.dsl.generator.plantuml.PlantUMLDiagramCreator;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class PlantUMLSubdomainClassDiagramCreator
extends AbstractPlantUMLClassDiagramCreator<Subdomain>
implements PlantUMLDiagramCreator<Subdomain> {
    private String domainName;

    public PlantUMLSubdomainClassDiagramCreator(String domainName) {
        this.domainName = domainName;
    }

    @Override
    protected void printDiagramContent(Subdomain subdomain) {
        this.relationships = Lists.newArrayList();
        this.extensions = Lists.newArrayList();
        this.domainObjects = EcoreUtil2.getAllContentsOfType((EObject)subdomain, SimpleDomainObject.class);
        this.printSubdomain(subdomain, 0);
        this.printReferences(0);
        this.printLegend(subdomain);
    }

    private void printSubdomain(Subdomain subdomain, int indentation) {
        this.printIndentation(indentation);
        this.sb.append("package ").append("\"'").append(subdomain.getName()).append("' ").append(this.getSubdomainTypeAsString(subdomain.getType())).append("\"").append(" <<Rectangle>> ").append("{");
        this.linebreak();
        for (SimpleDomainObject domainObject : subdomain.getEntities()) {
            this.printDomainObject(domainObject, indentation + 1);
        }
        this.printIndentation(indentation);
        this.sb.append("}");
        this.linebreak();
    }

    private void printLegend(Subdomain subdomain) {
        this.sb.append("legend left");
        this.linebreak();
        this.sb.append("  This subdomain is part of the '" + this.domainName + "' domain.");
        this.linebreak();
        if (subdomain.getDomainVisionStatement() != null) {
            this.linebreak();
            this.sb.append("  ").append(subdomain.getDomainVisionStatement());
            this.linebreak();
        }
        this.sb.append("end legend");
        this.linebreak();
    }

    private String getSubdomainTypeAsString(SubDomainType type) {
        switch (type) {
            case CORE_DOMAIN: {
                return "Core Domain";
            }
            case GENERIC_SUBDOMAIN: {
                return "Generic Subdomain";
            }
            case SUPPORTING_DOMAIN: {
                return "Supporting Domain";
            }
        }
        return "";
    }
}

