/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.servicecutter.output.converter;

import ch.hsr.servicecutter.api.ServiceCutterContext;
import ch.hsr.servicecutter.api.model.Service;
import ch.hsr.servicecutter.api.model.ServiceRelation;
import ch.hsr.servicecutter.api.model.SolverResult;
import ch.hsr.servicecutter.solver.SolverAlgorithm;
import ch.hsr.servicecutter.solver.SolverConfiguration;
import ch.hsr.servicecutter.solver.SolverPriority;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLModelObjectsResolvingHelper;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Domain;
import org.contextmapper.dsl.contextMappingDSL.Relationship;
import org.contextmapper.dsl.contextMappingDSL.SharedKernel;
import org.contextmapper.dsl.contextMappingDSL.Subdomain;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.contextMappingDSL.UserRequirement;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.Entity;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.TacticdslFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class ServiceCutterOutputToContextMappingModelConverter {
    private ContextMappingDSLFactory contextMappingFactory = ContextMappingDSLFactory.eINSTANCE;
    private TacticdslFactory tacticDDDFactory = TacticdslFactory.eINSTANCE;
    private Map<String, BoundedContext> boundedContextMap = new HashMap<String, BoundedContext>();
    private Map<String, String> attributeTypes = new HashMap<String, String>();
    private Set<String> referenceNames = new HashSet<String>();
    private Map<String, DomainObject> references2Reconstruct = new HashMap<String, DomainObject>();
    private ContextMappingModel originalModelState;
    private ContextMappingModel model;
    private ServiceCutterContext serviceCutterContext;
    private URI sclURI;

    public ServiceCutterOutputToContextMappingModelConverter() {
    }

    public ServiceCutterOutputToContextMappingModelConverter(ContextMappingModel originalModel, ServiceCutterContext serviceCutterContext) {
        this();
        this.originalModelState = originalModel;
        this.serviceCutterContext = serviceCutterContext;
        this.initializeTypeMapByOriginalCMLModel(originalModel);
    }

    public ServiceCutterOutputToContextMappingModelConverter(ContextMappingModel originalModel, ServiceCutterContext serviceCutterContext, URI sclUri) {
        this(originalModel, serviceCutterContext);
        this.sclURI = sclUri;
    }

    public ContextMappingModel convert(SolverResult serviceCutterResult) {
        this.model = this.contextMappingFactory.createContextMappingModel();
        ContextMap contextMap = this.contextMappingFactory.createContextMap();
        if (this.originalModelState != null && this.originalModelState.getMap() != null) {
            contextMap.setName(this.originalModelState.getMap().getName());
            contextMap.setState(this.originalModelState.getMap().getState());
            contextMap.setType(this.originalModelState.getMap().getType());
        }
        for (Service service : serviceCutterResult.getServices()) {
            BoundedContext bc = this.createOrGetBoundedContext(service.getName());
            bc.setComment(this.generateBCComment(service));
            Aggregate aggregate = this.contextMappingFactory.createAggregate();
            aggregate.setName("Aggregate_" + service.getId());
            aggregate.getDomainObjects().addAll(this.convertEntities(service.getId(), service.getNanoentities()));
            bc.getAggregates().add((Object)aggregate);
            this.model.getBoundedContexts().add((Object)bc);
            contextMap.getBoundedContexts().add((Object)bc);
        }
        contextMap.getRelationships().addAll(this.convertRelationships(serviceCutterResult.getRelations()));
        this.model.setMap(contextMap);
        this.reconstructReferencesIfPossible();
        this.copyRootElementsNotAffected();
        this.model.setTopComment(this.generateTopComment());
        return this.model;
    }

    private String generateTopComment() {
        StringBuilder sb = new StringBuilder();
        sb.append("/* This CML model has been generated with Service Cutter. Timestamp: " + new SimpleDateFormat("dd.MM.YYYY HH:mm:ss z").format(new Date()));
        if (this.originalModelState != null) {
            sb.append(System.lineSeparator() + " * It decomposes the original CML model " + this.originalModelState.eResource().getURI().toString() + ".");
        }
        if (this.sclURI != null) {
            sb.append(System.lineSeparator() + " * The following user representations file was used for the decomposition: " + this.sclURI.toString() + ".");
        }
        if (this.serviceCutterContext != null) {
            SolverConfiguration config = this.serviceCutterContext.getSolverConfiguration();
            sb.append(System.lineSeparator() + " * ");
            sb.append(System.lineSeparator() + " * The service cut was generated with the following input parameters (.servicecutter.yml):");
            sb.append(System.lineSeparator() + " * Algorithm: " + config.getAlgorithm().name());
            for (Map.Entry<String, Double> entry : this.getAlgorithmParameters4Algo(config.getAlgorithmParams(), config.getAlgorithm()).entrySet()) {
                sb.append(System.lineSeparator() + " * " + entry.getKey() + ": " + entry.getValue().toString());
            }
            for (Map.Entry<String, Double> entry : config.getPriorities().entrySet()) {
                sb.append(System.lineSeparator() + " * " + entry.getKey() + ": " + ((SolverPriority)entry.getValue()).name());
            }
        }
        sb.append(System.lineSeparator() + " */");
        return sb.toString();
    }

    private String generateBCComment(Service service) {
        StringBuilder sb = new StringBuilder();
        sb.append("/* This Bounded Context has been proposed by Service Cutter.");
        if (this.originalModelState != null) {
            sb.append(System.lineSeparator() + " * It contains parts of the domain models of the following original Bounded Contexts:");
            for (BoundedContext bc : this.collectOriginalBoundedContexts4Service(service)) {
                sb.append(System.lineSeparator() + " * - " + bc.getName());
            }
        }
        sb.append(System.lineSeparator() + " */");
        return sb.toString();
    }

    private Set<BoundedContext> collectOriginalBoundedContexts4Service(Service service) {
        HashSet bcs = Sets.newHashSet();
        for (String nanoEntity : service.getNanoentities()) {
            BoundedContext bc = this.getOriginalBoundedContext4Nanoentity(nanoEntity);
            if (bc == null) continue;
            bcs.add(bc);
        }
        return bcs;
    }

    private BoundedContext getOriginalBoundedContext4Nanoentity(String nanoEntity) {
        String entityName = nanoEntity.split("\\.")[0];
        String attributeName = nanoEntity.split("\\.")[1];
        for (DomainObject obj : EcoreUtil2.eAllOfType((EObject)this.originalModelState, DomainObject.class).stream().filter(o -> o.getName().equals(entityName)).collect(Collectors.toList())) {
            if (obj.getAttributes().stream().anyMatch(a -> a.getName().equals(attributeName))) {
                return new CMLModelObjectsResolvingHelper(this.originalModelState).resolveBoundedContext(obj);
            }
            if (!obj.getReferences().stream().anyMatch(r -> r.getName().equals(attributeName))) continue;
            return new CMLModelObjectsResolvingHelper(this.originalModelState).resolveBoundedContext(obj);
        }
        return null;
    }

    private Map<String, Double> getAlgorithmParameters4Algo(Map<String, Double> allParams, SolverAlgorithm algo) {
        HashMap algoParams = Maps.newHashMap();
        String prefix = this.getAlgoPrefix(algo);
        for (String paramKey : allParams.keySet()) {
            if (!paramKey.startsWith(prefix)) continue;
            algoParams.put(paramKey, allParams.get(paramKey));
        }
        return algoParams;
    }

    private String getAlgoPrefix(SolverAlgorithm algo) {
        HashMap prefixTable = Maps.newHashMap();
        prefixTable.put(SolverAlgorithm.LEUNG, "leung");
        prefixTable.put(SolverAlgorithm.CHINESE_WHISPERS, "cw");
        prefixTable.put(SolverAlgorithm.MARKOV_CLUSTERING, "mcl");
        return (String)prefixTable.get(algo);
    }

    private void copyRootElementsNotAffected() {
        if (this.originalModelState == null) {
            return;
        }
        this.model.getUserRequirements().addAll(EcoreUtil2.copyAll(this.originalModelState.getUserRequirements()));
        this.model.getImports().addAll(EcoreUtil2.copyAll(this.originalModelState.getImports()));
        this.model.getDomains().addAll(EcoreUtil2.copyAll(this.originalModelState.getDomains()));
        for (Domain domain : this.model.getDomains()) {
            this.reconstructSubdomainToFeatureReferences(domain);
        }
    }

    private void reconstructSubdomainToFeatureReferences(Domain domain) {
        for (Subdomain subdomain : domain.getSubdomains()) {
            this.reconstructSubdomainToFeatureReferences(subdomain);
        }
    }

    private void reconstructSubdomainToFeatureReferences(Subdomain subDomain) {
        LinkedList urReferences = Lists.newLinkedList();
        for (UserRequirement ur : subDomain.getSupportedFeatures()) {
            urReferences.add(this.model.getUserRequirements().stream().filter(u -> u.getName().equals(ur.getName())).findFirst().get());
        }
        subDomain.getSupportedFeatures().clear();
        subDomain.getSupportedFeatures().addAll((Collection)urReferences);
    }

    private List<Entity> convertEntities(char serviceId, List<String> nanoEntities) {
        HashMap entities = Maps.newHashMap();
        for (String nanoEntity : nanoEntities) {
            String entityName = nanoEntity.split("\\.")[0];
            String nanoEntityName = nanoEntity.split("\\.")[1];
            Entity entity = this.createOrGetEntity(entities, entityName);
            if (this.referenceNames.contains(nanoEntity)) {
                this.references2Reconstruct.put(nanoEntity, entity);
                continue;
            }
            Attribute attribute = this.tacticDDDFactory.createAttribute();
            if (this.attributeTypes.containsKey(nanoEntity)) {
                attribute.setType(this.attributeTypes.get(nanoEntity));
            } else {
                attribute.setType("UnknownType");
            }
            attribute.setName(nanoEntityName);
            entity.getAttributes().add((Object)attribute);
        }
        return Lists.newLinkedList(entities.values());
    }

    private Entity createOrGetEntity(Map<String, Entity> entities, String entityName) {
        if (entities.containsKey(entityName)) {
            return entities.get(entityName);
        }
        Entity entity = TacticdslFactory.eINSTANCE.createEntity();
        entity.setName(entityName);
        entities.put(entityName, entity);
        return entity;
    }

    private List<Relationship> convertRelationships(List<ServiceRelation> serviceRelations) {
        ArrayList relationships = Lists.newArrayList();
        for (ServiceRelation relation : serviceRelations) {
            if ("OUTGOING".equals(relation.getDirection().toString())) {
                relationships.add(this.createUpstreamDownstreamRelationship(this.createOrGetBoundedContext(relation.getServiceA()), this.createOrGetBoundedContext(relation.getServiceB())));
                continue;
            }
            if ("INCOMING".equals(relation.getDirection().toString())) {
                relationships.add(this.createUpstreamDownstreamRelationship(this.createOrGetBoundedContext(relation.getServiceB()), this.createOrGetBoundedContext(relation.getServiceA())));
                continue;
            }
            if (!"BIDIRECTIONAL".equals(relation.getDirection().toString())) continue;
            relationships.add(this.createSharedKernelRelationship(this.createOrGetBoundedContext(relation.getServiceA()), this.createOrGetBoundedContext(relation.getServiceB())));
        }
        return relationships;
    }

    private UpstreamDownstreamRelationship createUpstreamDownstreamRelationship(BoundedContext source, BoundedContext target) {
        UpstreamDownstreamRelationship relationship = this.contextMappingFactory.createUpstreamDownstreamRelationship();
        relationship.setUpstream(target);
        relationship.setDownstream(source);
        return relationship;
    }

    private SharedKernel createSharedKernelRelationship(BoundedContext context1, BoundedContext context2) {
        SharedKernel sharedKernel = this.contextMappingFactory.createSharedKernel();
        sharedKernel.setParticipant1(context1);
        sharedKernel.setParticipant2(context2);
        return sharedKernel;
    }

    private void initializeTypeMapByOriginalCMLModel(ContextMappingModel model) {
        List domainObjects = EcoreUtil2.getAllContentsOfType((EObject)model, DomainObject.class);
        for (DomainObject domainObject : domainObjects) {
            domainObject.getAttributes().stream().forEach(a -> this.attributeTypes.put(domainObject.getName() + "." + a.getName(), a.getType()));
            domainObject.getReferences().stream().forEach(r -> this.referenceNames.add(domainObject.getName() + "." + r.getName()));
        }
    }

    private BoundedContext createOrGetBoundedContext(String serviceName) {
        String boundedContextName = this.getBoundedContextName(serviceName);
        if (!this.boundedContextMap.containsKey(boundedContextName)) {
            BoundedContext bc = this.contextMappingFactory.createBoundedContext();
            bc.setName(boundedContextName);
            this.boundedContextMap.put(boundedContextName, bc);
        }
        return this.boundedContextMap.get(boundedContextName);
    }

    private String getBoundedContextName(String serviceName) {
        return serviceName.replace(" ", "_");
    }

    private void reconstructReferencesIfPossible() {
        if (this.originalModelState == null) {
            return;
        }
        List originalReferences = EcoreUtil2.eAllOfType((EObject)this.originalModelState, Reference.class);
        for (String referenceNanoEntity : this.references2Reconstruct.keySet()) {
            Optional<Reference> originalReference = originalReferences.stream().filter(r -> (((DomainObject)r.eContainer()).getName() + "." + r.getName()).equals(referenceNanoEntity)).findFirst();
            if (originalReference.isEmpty()) continue;
            this.reconstructReference(this.references2Reconstruct.get(referenceNanoEntity), originalReference.get(), originalReference.get().getDomainObjectType().getName());
        }
    }

    private void reconstructReference(DomainObject sourceObject, Reference originalReference, String targetTypeName) {
        BoundedContext parentBC = new CMLModelObjectsResolvingHelper(this.originalModelState).resolveBoundedContext(sourceObject);
        if (parentBC == null) {
            return;
        }
        List targetDomainObjects = EcoreUtil2.eAllOfType((EObject)this.model, DomainObject.class).stream().filter(obj -> obj.getName().equals(targetTypeName)).collect(Collectors.toList());
        if (targetDomainObjects.size() == 1) {
            Reference reference = TacticdslFactory.eINSTANCE.createReference();
            reference.setName(originalReference.getName());
            reference.setDomainObjectType((SimpleDomainObject)targetDomainObjects.get(0));
            reference.setCollectionType(originalReference.getCollectionType());
            reference.setDoc(originalReference.getDoc());
            sourceObject.getReferences().add((Object)reference);
        } else {
            sourceObject.setComment("/* Service Cut generator: it was not possible to reconstruct the reference '" + originalReference.getName() + "' from " + sourceObject.getName() + " to " + targetTypeName + ". Please re-create that reference manually. */");
        }
    }
}

