/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.sketchminer.converter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.contextmapper.dsl.cml.CMLModelObjectsResolvingHelper;
import org.contextmapper.dsl.contextMappingDSL.Application;
import org.contextmapper.dsl.contextMappingDSL.CommandInvokation;
import org.contextmapper.dsl.contextMappingDSL.CommandInvokationStep;
import org.contextmapper.dsl.contextMappingDSL.ConcurrentCommandInvokation;
import org.contextmapper.dsl.contextMappingDSL.ConcurrentOperationInvokation;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.DomainEventProductionStep;
import org.contextmapper.dsl.contextMappingDSL.EitherCommandOrOperation;
import org.contextmapper.dsl.contextMappingDSL.Flow;
import org.contextmapper.dsl.contextMappingDSL.FlowStep;
import org.contextmapper.dsl.contextMappingDSL.InclusiveAlternativeCommandInvokation;
import org.contextmapper.dsl.contextMappingDSL.InclusiveAlternativeEventProduction;
import org.contextmapper.dsl.contextMappingDSL.InclusiveAlternativeOperationInvokation;
import org.contextmapper.dsl.contextMappingDSL.MultipleEventProduction;
import org.contextmapper.dsl.contextMappingDSL.OperationInvokation;
import org.contextmapper.dsl.generator.sketchminer.converter.SimplifiedFlowStep;
import org.contextmapper.dsl.generator.sketchminer.model.SketchMinerModel;
import org.contextmapper.dsl.generator.sketchminer.model.Task;
import org.contextmapper.dsl.generator.sketchminer.model.TaskSequence;
import org.contextmapper.dsl.generator.sketchminer.model.TaskType;
import org.contextmapper.tactic.dsl.tacticdsl.StateTransition;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class Flow2SketchMinerConverter {
    private Flow flow;
    private List<SimplifiedFlowStep> simplifiedSteps;
    private Map<String, Task> taskMap;
    private SketchMinerModel model;

    public Flow2SketchMinerConverter(Flow flow) {
        this.flow = flow;
        this.model = new SketchMinerModel(this.getDefaultActorName(flow));
        this.initIntermediateTypes();
    }

    public SketchMinerModel convert() {
        for (Task initialTask : this.getInitialTasks()) {
            TaskSequence seq = new TaskSequence(initialTask);
            this.model.addSequence(seq);
            this.finishSequence(seq);
        }
        this.model.cleanupDuplicateSequences();
        return this.model;
    }

    private void finishSequence(TaskSequence seq) {
        Task lastTask = seq.getLastTaskInSequence();
        List<SimplifiedFlowStep> nextSteps = this.getNextSteps(lastTask);
        if (!nextSteps.isEmpty()) {
            for (SimplifiedFlowStep nextStep : nextSteps) {
                if (nextStep.getFroms().size() > 1 && !this.createParallelTask(nextStep.getFroms()).equals(lastTask)) {
                    seq.isSplittingFragment(true);
                    Task mergingTask = this.createParallelTask(nextStep.getFroms());
                    TaskSequence newSeq = new TaskSequence(mergingTask);
                    this.model.addSequence(newSeq);
                    newSeq.isMergingFragment(true);
                    this.finishSequence(newSeq);
                    continue;
                }
                if (nextStep.getTos().size() == 1) {
                    if (!seq.addTask(nextStep.getTos().iterator().next())) continue;
                    this.finishSequence(seq);
                    continue;
                }
                if (nextStep.getToType().equals((Object)SimplifiedFlowStep.ToType.AND)) {
                    this.endSequenceAsFragment(seq, nextStep.getTos());
                    continue;
                }
                this.forkSequence(seq, nextStep.getTos());
            }
        }
    }

    private void forkSequence(TaskSequence seq, Collection<Task> nextTasks) {
        Iterator<Task> it = nextTasks.iterator();
        Task firstTask = it.next();
        while (it.hasNext()) {
            Task nextTask = it.next();
            this.createNewSequenceWithTask(seq, nextTask);
        }
        if (seq.addTask(firstTask)) {
            this.finishSequence(seq);
        }
    }

    private void endSequenceAsFragment(TaskSequence seq, Collection<Task> nextTasks) {
        seq.isSplittingFragment(true);
        seq.addTask(this.createParallelTask(nextTasks));
        for (Task task : nextTasks) {
            TaskSequence newSeq = new TaskSequence(task);
            newSeq.isMergingFragment(true);
            this.model.addSequence(newSeq);
            this.finishSequence(newSeq);
        }
    }

    private void createNewSequenceWithTask(TaskSequence seq, Task nextTask) {
        TaskSequence newSeq = seq.copy();
        if (newSeq.addTask(nextTask)) {
            this.finishSequence(newSeq);
        }
        this.model.addSequence(newSeq);
    }

    private Task createParallelTask(Collection<Task> allTasks) {
        Iterator<Task> it = allTasks.iterator();
        Task firstTask = it.next();
        LinkedList parallelTasks = Lists.newLinkedList();
        while (it.hasNext()) {
            parallelTasks.add(it.next());
        }
        return new Task(firstTask.getName(), firstTask.getType(), parallelTasks);
    }

    private List<SimplifiedFlowStep> getNextSteps(Task lastTask) {
        LinkedList nextSteps = Lists.newLinkedList();
        for (SimplifiedFlowStep step : this.simplifiedSteps) {
            for (Task task : step.getFroms()) {
                if (!task.equalsOrContainsTask(lastTask)) continue;
                nextSteps.add(step);
            }
        }
        return nextSteps;
    }

    private void initIntermediateTypes() {
        this.simplifiedSteps = Lists.newLinkedList();
        this.taskMap = Maps.newLinkedHashMap();
        for (FlowStep step : this.flow.getSteps()) {
            this.simplifiedSteps.add(this.convert(step));
        }
    }

    private SimplifiedFlowStep convert(FlowStep step) {
        LinkedHashSet froms = Sets.newLinkedHashSet();
        LinkedHashSet tos = Sets.newLinkedHashSet();
        SimplifiedFlowStep.ToType toType = SimplifiedFlowStep.ToType.XOR;
        if (step instanceof CommandInvokationStep) {
            froms.addAll(((CommandInvokationStep)step).getEvents().stream().map(e -> this.getOrCreateTask(e.getName(), TaskType.EVENT)).collect(Collectors.toList()));
            if (((CommandInvokationStep)step).getAction() instanceof CommandInvokation) {
                CommandInvokation commandInvokation = (CommandInvokation)((CommandInvokationStep)step).getAction();
                tos.addAll(commandInvokation.getCommands().stream().map(c -> this.getOrCreateTask(c.getName(), TaskType.COMMAND)).collect(Collectors.toList()));
                if (commandInvokation instanceof ConcurrentCommandInvokation) {
                    toType = SimplifiedFlowStep.ToType.AND;
                }
                if (commandInvokation instanceof InclusiveAlternativeCommandInvokation) {
                    toType = SimplifiedFlowStep.ToType.OR;
                }
            } else if (((CommandInvokationStep)step).getAction() instanceof OperationInvokation) {
                OperationInvokation operationInvokation = (OperationInvokation)((CommandInvokationStep)step).getAction();
                tos.addAll(operationInvokation.getOperations().stream().map(o -> this.getOrCreateTask(o.getName(), TaskType.COMMAND)).collect(Collectors.toList()));
                if (operationInvokation instanceof ConcurrentOperationInvokation) {
                    toType = SimplifiedFlowStep.ToType.AND;
                }
                if (operationInvokation instanceof InclusiveAlternativeOperationInvokation) {
                    toType = SimplifiedFlowStep.ToType.OR;
                }
            }
        } else if (step instanceof DomainEventProductionStep) {
            DomainEventProductionStep eventStep = (DomainEventProductionStep)step;
            froms.add(this.createTask4EventProduction(eventStep));
            tos.addAll(eventStep.getEventProduction().getEvents().stream().map(e -> this.getOrCreateTask(e.getName(), TaskType.EVENT)).collect(Collectors.toList()));
            if (eventStep.getEventProduction() instanceof MultipleEventProduction) {
                toType = SimplifiedFlowStep.ToType.AND;
            }
            if (eventStep.getEventProduction() instanceof InclusiveAlternativeEventProduction) {
                toType = SimplifiedFlowStep.ToType.OR;
            }
        }
        return new SimplifiedFlowStep(froms, tos, toType);
    }

    private Task getOrCreateTask(String name, TaskType type) {
        if (this.taskMap.containsKey(name)) {
            return this.taskMap.get(name);
        }
        Task task = new Task(name, type);
        this.taskMap.put(name, task);
        return task;
    }

    private Task createTask4EventProduction(DomainEventProductionStep eventStep) {
        String name = "UndefinedTask";
        if (eventStep.getAction().getCommand() != null) {
            name = eventStep.getAction().getCommand().getName();
        } else if (eventStep.getAction().getOperation() != null) {
            name = eventStep.getAction().getOperation().getName();
        }
        Task task = this.getOrCreateTask(name, TaskType.COMMAND);
        this.addStateTransitionIfAvailable(task, eventStep);
        this.addActorIfAvailable(task, eventStep.getAction());
        return task;
    }

    private void addStateTransitionIfAvailable(Task task, DomainEventProductionStep step) {
        if (step.getAggregate() == null || step.getStateTransition() == null) {
            return;
        }
        task.setComment(step.getAggregate().getName() + " [" + this.getStateTransitionAsString(step.getStateTransition()) + "]");
    }

    private void addActorIfAvailable(Task task, EitherCommandOrOperation action) {
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{action.getActor()})) {
            task.setActor(action.getActor().trim());
        }
    }

    private String getStateTransitionAsString(StateTransition transition) {
        return String.join((CharSequence)", ", transition.getFrom().stream().map(v -> v.getName()).collect(Collectors.toList())) + " -> " + String.join((CharSequence)" X ", transition.getTarget().getTo().stream().map(t -> t.getValue().getName()).collect(Collectors.toList()));
    }

    private List<Task> getInitialTasks() {
        LinkedList initialTasks = Lists.newLinkedList();
        for (Task task : this.taskMap.values()) {
            if (!this.isInitialTask(task)) continue;
            initialTasks.add(task);
        }
        if (initialTasks.isEmpty()) {
            SimplifiedFlowStep firstStep = this.simplifiedSteps.get(0);
            Task generatedStartTask = new Task(this.getGeneratedStartName(), TaskType.EVENT);
            LinkedHashSet generatedFroms = Sets.newLinkedHashSet();
            LinkedHashSet generatedTos = Sets.newLinkedHashSet();
            generatedFroms.add(generatedStartTask);
            generatedTos.add(firstStep.getFroms().iterator().next());
            SimplifiedFlowStep generatedStep = new SimplifiedFlowStep(generatedFroms, generatedTos, SimplifiedFlowStep.ToType.OR);
            this.simplifiedSteps.add(generatedStep);
            initialTasks.add(generatedStartTask);
        }
        return initialTasks;
    }

    private String getGeneratedStartName() {
        String initName;
        String name = initName = "Start";
        int counter = 0;
        while (this.taskMap.keySet().contains(name)) {
            name = initName + counter;
            ++counter;
        }
        return name;
    }

    private boolean isInitialTask(Task potentialInitTask) {
        for (SimplifiedFlowStep step : this.simplifiedSteps) {
            if (!step.getTos().contains(potentialInitTask)) continue;
            return false;
        }
        return true;
    }

    private String getDefaultActorName(Flow flow) {
        if (flow.eContainer() instanceof Application && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{((Application)flow.eContainer()).getName()})) {
            return ((Application)flow.eContainer()).getName();
        }
        if (EcoreUtil2.getRootContainer((EObject)flow) instanceof ContextMappingModel) {
            return new CMLModelObjectsResolvingHelper((ContextMappingModel)EcoreUtil2.getRootContainer((EObject)flow)).resolveBoundedContext(flow).getName() + " Application";
        }
        return "Application";
    }
}

