/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring.henshin;

import java.util.List;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.contextMappingDSL.Relationship;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.refactoring.henshin.AbstractHenshinRefactoring;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.xtext.EcoreUtil2;

public class SplitAggregateByEntitiesRefactoring
extends AbstractHenshinRefactoring {
    private static final String TEMP_AGGREGATE_NAMES = "TEMP_AR_New_Aggregate";
    private static final String NEW_AGGREGATE_NAME_PREFIX = "NewAggregate";
    private String aggregateName;
    private List<Aggregate> newAggregates;

    public SplitAggregateByEntitiesRefactoring(String aggregateName) {
        this.aggregateName = aggregateName;
    }

    @Override
    protected String getHenshinTransformationFilename() {
        Aggregate selectedAggregate = this.getSelectedAggregate(this.getTransformationResource().getContextMappingModel());
        if (selectedAggregate != null && selectedAggregate.eContainer() instanceof SculptorModule) {
            return "SplitAggregateByEntities_WithModule.henshin";
        }
        return "SplitAggregateByEntities.henshin";
    }

    @Override
    protected String getTransformationUnitName() {
        return "splitAggregateByEntities";
    }

    @Override
    protected void setUnitParameters(UnitApplication refactoringUnit) {
        refactoringUnit.setParameterValue("aggregateName", (Object)this.aggregateName);
        refactoringUnit.setParameterValue("newAggregateName", (Object)TEMP_AGGREGATE_NAMES);
    }

    @Override
    protected void throwTransformationError() {
        throw new RuntimeException("Error splitting by aggregate '" + this.aggregateName + "' ... (Problem with Henshin transformation)");
    }

    @Override
    protected void postProcessing(CMLResource resource) {
        ContextMappingModel model = resource.getContextMappingModel();
        Aggregate inputAggregate = this.getSelectedAggregate(model);
        if (inputAggregate == null) {
            return;
        }
        this.setAggregateRoot(inputAggregate);
        if (inputAggregate.eContainer() instanceof BoundedContext) {
            BoundedContext bc = (BoundedContext)inputAggregate.eContainer();
            this.fixNewAggregateNamesAndSetRoot((List<Aggregate>)bc.getAggregates());
        } else if (inputAggregate.eContainer() instanceof SculptorModule) {
            SculptorModule m = (SculptorModule)inputAggregate.eContainer();
            this.fixNewAggregateNamesAndSetRoot((List<Aggregate>)m.getAggregates());
        }
        for (ContextMap contextMap : this.getAllContextMaps()) {
            this.addNewAggregatesToExposedAggregatesIfOriginalIsExposed(contextMap);
        }
    }

    private void fixNewAggregateNamesAndSetRoot(List<Aggregate> aggregates) {
        this.newAggregates = aggregates.stream().filter(agg -> agg.getName().equals(TEMP_AGGREGATE_NAMES)).collect(Collectors.toList());
        int i = 1;
        for (Aggregate newAggregate : this.newAggregates) {
            newAggregate.setName(NEW_AGGREGATE_NAME_PREFIX + i);
            this.setAggregateRoot(newAggregate);
            ++i;
        }
    }

    private void setAggregateRoot(Aggregate aggregate) {
        SimpleDomainObject object;
        if (aggregate.getDomainObjects().size() == 1 && (object = (SimpleDomainObject)aggregate.getDomainObjects().get(0)) instanceof DomainObject) {
            ((DomainObject)object).setAggregateRoot(true);
        }
    }

    private Aggregate getSelectedAggregate(ContextMappingModel model) {
        List allAggregates = EcoreUtil2.getAllContentsOfType((EObject)model, Aggregate.class);
        List aggregatesWithInputName = allAggregates.stream().filter(agg -> agg.getName().equals(this.aggregateName)).collect(Collectors.toList());
        if (aggregatesWithInputName.isEmpty()) {
            return null;
        }
        return (Aggregate)aggregatesWithInputName.get(0);
    }

    private void addNewAggregatesToExposedAggregatesIfOriginalIsExposed(ContextMap contextMap) {
        for (Relationship relationship : contextMap.getRelationships()) {
            UpstreamDownstreamRelationship upDownRelationship;
            if (!(relationship instanceof UpstreamDownstreamRelationship) || !(upDownRelationship = (UpstreamDownstreamRelationship)relationship).getUpstreamExposedAggregates().stream().map(a -> a.getName()).collect(Collectors.toList()).contains(this.aggregateName)) continue;
            this.addElementsToEList(upDownRelationship.getUpstreamExposedAggregates(), this.newAggregates);
        }
    }

    @Override
    protected CMLResource getTransformationResource() {
        for (BoundedContext boundedContext : this.getAllBoundedContexts()) {
            List bcAggregates = EcoreUtil2.getAllContentsOfType((EObject)boundedContext, Aggregate.class);
            List aggregatesWithInputName = bcAggregates.stream().filter(agg -> agg.getName().equals(this.aggregateName)).collect(Collectors.toList());
            if (aggregatesWithInputName.isEmpty()) continue;
            return this.getResource(boundedContext);
        }
        return this.rootResource;
    }
}

