/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.standalone;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import org.contextmapper.dsl.ContextMappingDSLStandaloneSetup;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.contextmapper.dsl.standalone.FileSystemHelper;
import org.contextmapper.dsl.standalone.StandaloneContextMapperAPI;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.serializer.ISerializer;

public class StandaloneContextMapper
implements StandaloneContextMapperAPI {
    @Inject
    private ISerializer serializer;

    public StandaloneContextMapper() {
        Injector injector = new ContextMappingDSLStandaloneSetup().createInjectorAndDoEMFRegistration();
        injector.injectMembers((Object)this);
    }

    @Override
    public CMLResource loadCML(String filepath) {
        return new CMLResource(new ResourceSetImpl().getResource(URI.createURI((String)filepath), true));
    }

    @Override
    public CMLResource loadCML(File cmlFile) {
        return new CMLResource(new ResourceSetImpl().getResource(URI.createFileURI((String)cmlFile.getAbsolutePath()), true));
    }

    @Override
    public void callGenerator(CMLResource cml, IGenerator2 generator) {
        generator.doGenerate((Resource)cml, (IFileSystemAccess2)FileSystemHelper.getFileSystemAccess(), (IGeneratorContext)new GeneratorContext());
    }

    @Override
    public void callGenerator(CMLResource cml, IGenerator2 generator, String outputDir) {
        generator.doGenerate((Resource)cml, (IFileSystemAccess2)FileSystemHelper.getFileSystemAccess(outputDir), (IGeneratorContext)new GeneratorContext());
    }

    @Override
    public CMLResource createCML(String filepath) {
        return this.createNewCMLResource(new File(filepath));
    }

    @Override
    public CMLResource createCML(File cmlFile) {
        return this.createNewCMLResource(cmlFile);
    }

    private CMLResource createNewCMLResource(File file) {
        Resource resource = new ResourceSetImpl().createResource(URI.createFileURI((String)file.getAbsolutePath()));
        resource.getContents().add((Object)ContextMappingDSLFactory.eINSTANCE.createContextMappingModel());
        return new CMLResource(resource);
    }

    @Override
    public void applyRefactoring(CMLResource cml, SemanticCMLRefactoring refactoring) {
        refactoring.refactor(cml);
        refactoring.persistChanges(this.serializer);
    }
}

