/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.servicecutter.dsl.scl;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.contextmapper.servicecutter.dsl.scl.exception.ResourceIsNoSCLModelException;
import org.contextmapper.servicecutter.dsl.serviceCutterConfigurationDSL.ServiceCutterUserRepresentationsModel;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;

public class SCLResourceContainer {
    private final Resource resource;

    public SCLResourceContainer(Resource resource) {
        if (resource.getContents().isEmpty()) {
            this.throwResourceIsNoSCLModelException(resource);
        }
        if (!(resource.getContents().get(0) instanceof ServiceCutterUserRepresentationsModel)) {
            this.throwResourceIsNoSCLModelException(resource);
        }
        this.resource = resource;
        this.resource.setTrackingModification(true);
    }

    public Resource getResource() {
        return this.resource;
    }

    public ServiceCutterUserRepresentationsModel getServiceCutterConfigurationModel() {
        List serviceCutterModels = IteratorExtensions.toList((Iterator)Iterators.filter((Iterator)this.resource.getAllContents(), ServiceCutterUserRepresentationsModel.class));
        return (ServiceCutterUserRepresentationsModel)serviceCutterModels.get(0);
    }

    private void throwResourceIsNoSCLModelException(Resource resource) {
        if (resource.getURI() != null) {
            throw new ResourceIsNoSCLModelException(resource.getURI());
        }
        throw new ResourceIsNoSCLModelException();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SCLResourceContainer)) {
            return false;
        }
        SCLResourceContainer otherResource = (SCLResourceContainer)obj;
        return this.resource.getURI().equals(otherResource.resource.getURI());
    }

    public int hashCode() {
        return this.resource.getURI().hashCode();
    }
}

