/*
 * Decompiled with CFR 0.152.
 */
package ch.hsr.servicecutter.api;

import ch.hsr.servicecutter.model.criteria.CouplingCriteriaCatalog;
import ch.hsr.servicecutter.model.criteria.CouplingCriterionCharacteristic;
import ch.hsr.servicecutter.model.criteria.CouplingType;
import ch.hsr.servicecutter.model.usersystem.CouplingInstance;
import ch.hsr.servicecutter.model.usersystem.Nanoentity;
import ch.hsr.servicecutter.solver.SolverConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ServiceCutterContext {
    private String systemName;
    private SolverConfiguration solverConfiguration;
    private CouplingCriteriaCatalog criteriaCatalog;
    private List<CouplingInstance> couplingInstances;
    private Set<Nanoentity> nanoEntities;

    public ServiceCutterContext(String systemName) {
        this.systemName = systemName;
        this.criteriaCatalog = new CouplingCriteriaCatalog();
        this.couplingInstances = new ArrayList<CouplingInstance>();
        this.nanoEntities = new HashSet<Nanoentity>();
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSolverConfiguration(SolverConfiguration solverConfiguration) {
        this.solverConfiguration = solverConfiguration;
    }

    public SolverConfiguration getSolverConfiguration() {
        return this.solverConfiguration;
    }

    public CouplingCriteriaCatalog getCriteriaCatalog() {
        return this.criteriaCatalog;
    }

    public void addCouplingInstance(CouplingInstance couplingInstance) {
        this.couplingInstances.add(couplingInstance);
    }

    public List<CouplingInstance> getCouplingInstances() {
        return this.couplingInstances;
    }

    public void addNanoEntity(Nanoentity nanoentity) {
        this.nanoEntities.add(nanoentity);
    }

    public Set<Nanoentity> getNanoEntities() {
        return Collections.unmodifiableSet(this.nanoEntities);
    }

    public Optional<Nanoentity> findNanoEntityByContextAndName(String context, String name) {
        return this.nanoEntities.stream().filter(ne -> ne.getContext().equals(context) && ne.getName().equals(name)).findFirst();
    }

    public Optional<Nanoentity> findNanoEntityByName(String name) {
        return this.nanoEntities.stream().filter(ne -> ne.getName().equals(name)).findFirst();
    }

    public Set<CouplingInstance> findCouplingInstancesByCharacteristic(CouplingCriterionCharacteristic characteristic) {
        return this.couplingInstances.stream().filter(ci -> ci.getCharacteristic() != null && ci.getCharacteristic().equals(characteristic)).collect(Collectors.toSet());
    }

    public Map<String, Set<CouplingInstance>> findCouplingInstancesGroupedByCriterionFilteredByCriterionType(CouplingType couplingType) {
        return this.groupByCriterion(this.getCouplingInstances().stream().filter(instance -> couplingType.equals((Object)instance.getCouplingCriterion().getType())).collect(Collectors.toSet()));
    }

    private Map<String, Set<CouplingInstance>> groupByCriterion(Set<CouplingInstance> instances) {
        HashMap<String, Set<CouplingInstance>> instancesByCriterion = new HashMap<String, Set<CouplingInstance>>();
        for (CouplingInstance instance : instances) {
            String ccName = instance.getCouplingCriterion().getName();
            if (instancesByCriterion.get(ccName) == null) {
                instancesByCriterion.put(ccName, new HashSet());
            }
            ((Set)instancesByCriterion.get(ccName)).add(instance);
        }
        return instancesByCriterion;
    }
}

