/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer.basicRenderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.graphstream.graph.Element;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.StyleGroupSet;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.Value;
import org.graphstream.ui.swingViewer.GraphRendererBase;
import org.graphstream.ui.swingViewer.LayerRenderer;
import org.graphstream.ui.swingViewer.basicRenderer.EdgeRenderer;
import org.graphstream.ui.swingViewer.basicRenderer.NodeRenderer;
import org.graphstream.ui.swingViewer.basicRenderer.SpriteRenderer;
import org.graphstream.ui.swingViewer.util.DefaultCamera;
import org.graphstream.ui.swingViewer.util.GraphMetrics;
import org.graphstream.ui.swingViewer.util.Graphics2DOutput;
import org.graphstream.ui.view.Camera;

public class SwingBasicGraphRenderer
extends GraphRendererBase {
    private static final Logger logger = Logger.getLogger(SwingBasicGraphRenderer.class.getName());
    protected DefaultCamera camera = null;
    protected NodeRenderer nodeRenderer = new NodeRenderer();
    protected EdgeRenderer edgeRenderer = new EdgeRenderer();
    protected SpriteRenderer spriteRenderer = new SpriteRenderer();
    protected LayerRenderer backRenderer = null;
    protected LayerRenderer foreRenderer = null;
    protected PrintStream fpsLog = null;
    protected long T1 = 0L;
    protected long steps = 0L;
    protected double sumFps = 0.0;

    @Override
    public void open(GraphicGraph graph, Container renderingSurface) {
        super.open(graph, renderingSurface);
        this.camera = new DefaultCamera(graph);
    }

    @Override
    public void close() {
        if (this.fpsLog != null) {
            this.fpsLog.flush();
            this.fpsLog.close();
            this.fpsLog = null;
        }
        this.camera = null;
        super.close();
    }

    @Override
    public Camera getCamera() {
        return this.camera;
    }

    @Override
    public Collection<GraphicElement> allNodesOrSpritesIn(double x1, double y1, double x2, double y2) {
        return this.camera.allNodesOrSpritesIn(this.graph, x1, y1, x2, y2);
    }

    @Override
    public GraphicElement findNodeOrSpriteAt(double x, double y) {
        return this.camera.findNodeOrSpriteAt(this.graph, x, y);
    }

    @Override
    public void render(Graphics2D g, int x, int y, int width, int height) {
        if (this.graph != null && g != null && this.camera != null) {
            this.beginFrame();
            if (this.camera.getGraphViewport() == null && this.camera.getMetrics().diagonal == 0.0 && this.graph.getNodeCount() == 0 && this.graph.getSpriteCount() == 0) {
                this.displayNothingToDo(g, width, height);
            } else {
                this.camera.setPadding(this.graph);
                this.camera.setViewport(x, y, width, height);
                this.renderGraph(g);
                this.renderSelection(g);
            }
            this.endFrame();
        }
    }

    protected void beginFrame() {
        if (this.graph.hasLabel("ui.log") && this.fpsLog == null) {
            try {
                this.fpsLog = new PrintStream(this.graph.getLabel("ui.log").toString());
            }
            catch (IOException e) {
                this.fpsLog = null;
                e.printStackTrace();
            }
        }
        if (this.fpsLog != null) {
            this.T1 = System.currentTimeMillis();
        }
    }

    protected void endFrame() {
        if (this.fpsLog != null) {
            ++this.steps;
            long T2 = System.currentTimeMillis();
            long time = T2 - this.T1;
            double fps = 1000.0 / (double)time;
            this.sumFps += fps;
            this.fpsLog.printf("%.3f   %d   %.3f%n", fps, time, this.sumFps / (double)this.steps);
        }
    }

    @Override
    public void moveElementAtPx(GraphicElement element, double x, double y) {
        Point3 p = this.camera.transformPxToGu(this.camera.getMetrics().viewport[0] + x, this.camera.getMetrics().viewport[1] + y);
        element.move(p.x, p.y, element.getZ());
    }

    protected void renderGraph(Graphics2D g) {
        StyleGroup style = this.graph.getStyle();
        this.setupGraphics(g);
        this.renderGraphBackground(g);
        this.renderBackLayer(g);
        this.camera.pushView(this.graph, g);
        this.renderGraphElements(g);
        if (style.getStrokeMode() != StyleConstants.StrokeMode.NONE && style.getStrokeWidth().value != 0.0) {
            GraphMetrics metrics = this.camera.getMetrics();
            Rectangle2D.Double rect = new Rectangle2D.Double();
            double px1 = metrics.px1;
            Value stroke = style.getShadowWidth();
            rect.setFrame(metrics.lo.x, metrics.lo.y + px1, metrics.size.data[0] - px1, metrics.size.data[1] - px1);
            g.setStroke(new BasicStroke((float)metrics.lengthToGu(stroke)));
            g.setColor(this.graph.getStyle().getStrokeColor(0));
            g.draw(rect);
        }
        this.camera.popView(g);
        this.renderForeLayer(g);
    }

    protected void setupGraphics(Graphics2D g) {
        if (this.graph.hasAttribute("ui.antialias")) {
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.graph.hasAttribute("ui.quality")) {
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        } else {
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        }
    }

    protected void renderGraphBackground(Graphics2D g) {
        StyleGroup group = this.graph.getStyle();
        if (group.getFillMode() != StyleConstants.FillMode.NONE) {
            g.setColor(group.getFillColor(0));
            g.fillRect(0, 0, (int)this.camera.getMetrics().viewport[2], (int)this.camera.getMetrics().viewport[3]);
        }
    }

    protected void renderGraphElements(Graphics2D g) {
        try {
            StyleGroupSet sgs = this.graph.getStyleGroups();
            if (sgs != null) {
                for (HashSet<StyleGroup> groups : sgs.zIndex()) {
                    for (StyleGroup group : groups) {
                        this.renderGroup(g, group);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unexpected error during graph render.", e);
        }
    }

    protected void renderGroup(Graphics2D g, StyleGroup group) {
        switch (group.getType()) {
            case NODE: {
                this.nodeRenderer.render(group, g, this.camera);
                break;
            }
            case EDGE: {
                this.edgeRenderer.render(group, g, this.camera);
                break;
            }
            case SPRITE: {
                this.spriteRenderer.render(group, g, this.camera);
                break;
            }
        }
    }

    protected void setupSpriteStyle(Graphics2D g, StyleGroup group) {
        g.setColor(group.getFillColor(0));
    }

    protected void renderSelection(Graphics2D g) {
        if (this.selection != null && this.selection.x1 != this.selection.x2 && this.selection.y1 != this.selection.y2) {
            double t;
            double x1 = this.selection.x1;
            double y1 = this.selection.y1;
            double x2 = this.selection.x2;
            double y2 = this.selection.y2;
            double w = this.camera.getMetrics().getSize().data[0];
            double h = this.camera.getMetrics().getSize().data[1];
            if (x1 > x2) {
                t = x1;
                x1 = x2;
                x2 = t;
            }
            if (y1 > y2) {
                t = y1;
                y1 = y2;
                y2 = t;
            }
            Stroke s = g.getStroke();
            g.setStroke(new BasicStroke(1.0f));
            g.setColor(new Color(50, 50, 200, 128));
            g.fillRect((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
            g.setColor(new Color(0, 0, 0, 128));
            g.drawLine(0, (int)y1, (int)w, (int)y1);
            g.drawLine(0, (int)y2, (int)w, (int)y2);
            g.drawLine((int)x1, 0, (int)x1, (int)h);
            g.drawLine((int)x2, 0, (int)x2, (int)h);
            g.setColor(new Color(50, 50, 200, 64));
            g.drawRect((int)x1, (int)y1, (int)(x2 - x1), (int)(y2 - y1));
            g.setStroke(s);
        }
    }

    protected void renderBackLayer(Graphics2D g) {
        if (this.backRenderer != null) {
            this.renderLayer(g, this.backRenderer);
        }
    }

    protected void renderForeLayer(Graphics2D g) {
        if (this.foreRenderer != null) {
            this.renderLayer(g, this.foreRenderer);
        }
    }

    protected void renderLayer(Graphics2D g, LayerRenderer renderer) {
        GraphMetrics metrics = this.camera.getMetrics();
        renderer.render(g, this.graph, metrics.ratioPx2Gu, (int)metrics.viewport[2], (int)metrics.viewport[3], metrics.loVisible.x, metrics.loVisible.y, metrics.hiVisible.x, metrics.hiVisible.y);
    }

    protected void debugVisibleArea(Graphics2D g) {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        GraphMetrics metrics = this.camera.getMetrics();
        double x = metrics.loVisible.x;
        double y = metrics.loVisible.y;
        double w = Math.abs(metrics.hiVisible.x - x);
        double h = Math.abs(metrics.hiVisible.y - y);
        rect.setFrame(x, y, w, h);
        g.setStroke(new BasicStroke((float)(metrics.px1 * 4.0)));
        g.setColor(Color.RED);
        g.draw(rect);
        g.setColor(Color.BLUE);
        Ellipse2D.Double ellipse = new Ellipse2D.Double();
        double px1 = metrics.px1;
        ((RectangularShape)ellipse).setFrame(this.camera.getViewCenter().x - 3.0 * px1, this.camera.getViewCenter().y - 3.0 * px1, px1 * 6.0, px1 * 6.0);
        g.fill(ellipse);
        ((RectangularShape)ellipse).setFrame(metrics.lo.x - 3.0 * px1, metrics.lo.y - 3.0 * px1, px1 * 6.0, px1 * 6.0);
        g.fill(ellipse);
        ((RectangularShape)ellipse).setFrame(metrics.hi.x - 3.0 * px1, metrics.hi.y - 3.0 * px1, px1 * 6.0, px1 * 6.0);
        g.fill(ellipse);
    }

    @Override
    public void screenshot(String filename, int width, int height) {
        if (this.graph != null) {
            if (filename.endsWith("png") || filename.endsWith("PNG")) {
                BufferedImage img = new BufferedImage(width, height, 2);
                this.renderGraph(img.createGraphics());
                File file = new File(filename);
                try {
                    ImageIO.write((RenderedImage)img, "png", file);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (filename.endsWith("bmp") || filename.endsWith("BMP")) {
                BufferedImage img = new BufferedImage(width, height, 1);
                this.renderGraph(img.createGraphics());
                File file = new File(filename);
                try {
                    ImageIO.write((RenderedImage)img, "bmp", file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (filename.endsWith("jpg") || filename.endsWith("JPG") || filename.endsWith("jpeg") || filename.endsWith("JPEG")) {
                BufferedImage img = new BufferedImage(width, height, 1);
                this.renderGraph(img.createGraphics());
                File file = new File(filename);
                try {
                    ImageIO.write((RenderedImage)img, "jpg", file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (filename.toLowerCase().endsWith("svg")) {
                try {
                    String plugin = "org.graphstream.ui.batik.BatikGraphics2D";
                    Class<?> c = Class.forName(plugin);
                    Object o = c.newInstance();
                    if (o instanceof Graphics2DOutput) {
                        Graphics2DOutput out = (Graphics2DOutput)o;
                        Graphics2D g2 = out.getGraphics();
                        this.render(g2, (int)this.camera.getMetrics().viewport[0], (int)this.camera.getMetrics().viewport[1], (int)this.camera.getMetrics().viewport[2], (int)this.camera.getMetrics().viewport[3]);
                        out.outputTo(filename);
                    } else {
                        logger.warning(String.format("Plugin %s is not an instance of Graphics2DOutput (%s).", plugin, o.getClass().getName()));
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Unexpected error during screen shot.", e);
                }
            }
        }
    }

    @Override
    public void setBackLayerRenderer(LayerRenderer renderer) {
        this.backRenderer = renderer;
    }

    @Override
    public void setForeLayoutRenderer(LayerRenderer renderer) {
        this.foreRenderer = renderer;
    }

    @Override
    public void elementStyleChanged(Element element, StyleGroup oldStyle, StyleGroup style) {
    }
}

