/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.Application;
import org.nlpub.watset.graph.EmptyClustering;
import org.nlpub.watset.graph.SimplifiedWatset;
import org.nlpub.watset.graph.Watset;
import org.nlpub.watset.util.AlgorithmProvider;
import org.nlpub.watset.util.CosineContextSimilarity;
import org.nlpub.watset.util.IndexedSense;
import org.nlpub.watset.util.Sense;

class CommandSenses {
    final Application application;
    @Parameter(required=true, description="Local clustering algorithm", names={"-l", "--local"})
    String local;
    @Parameter(description="Local clustering algorithm parameters", names={"-lp", "--local-params"})
    String localParams;
    @Parameter(description="Use Simplified Watset", names={"-s", "--simplified"})
    boolean simplified = false;

    public CommandSenses(Application application) {
        this.application = application;
    }

    public void run() {
        Objects.requireNonNull(this.local);
        AlgorithmProvider<String, DefaultWeightedEdge> algorithm = new AlgorithmProvider<String, DefaultWeightedEdge>(this.local, this.localParams);
        Graph<String, DefaultWeightedEdge> graph = this.application.getGraph();
        Map<Sense<String>, Map<Sense<String>, Number>> contexts = this.simplified ? this.getSimplifiedWatsetContexts(algorithm, graph) : this.getWatsetContexts(algorithm, graph);
        try {
            this.write(this.application.output, contexts);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void write(Path path, Map<Sense<String>, Map<Sense<String>, Number>> contexts) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (Map.Entry<Sense<String>, Map<Sense<String>, Number>> context : contexts.entrySet()) {
                IndexedSense sense = (IndexedSense)context.getKey();
                String contextRecord = context.getValue().entrySet().stream().map(e -> String.format(Locale.ROOT, "%s#%d:%f", ((Sense)e.getKey()).get(), ((IndexedSense)e.getKey()).getSense(), ((Number)e.getValue()).doubleValue())).collect(Collectors.joining(","));
                writer.write(String.format(Locale.ROOT, "%s\t%d\t%s%n", sense.get(), sense.getSense(), contextRecord));
            }
        }
    }

    public Map<Sense<String>, Map<Sense<String>, Number>> getWatsetContexts(AlgorithmProvider<String, DefaultWeightedEdge> algorithm, Graph<String, DefaultWeightedEdge> graph) {
        Watset<String, DefaultWeightedEdge> watset = new Watset<String, DefaultWeightedEdge>(graph, algorithm, EmptyClustering.provider(), new CosineContextSimilarity());
        watset.fit();
        return watset.getContexts();
    }

    public Map<Sense<String>, Map<Sense<String>, Number>> getSimplifiedWatsetContexts(AlgorithmProvider<String, DefaultWeightedEdge> algorithm, Graph<String, DefaultWeightedEdge> graph) {
        SimplifiedWatset<String, DefaultWeightedEdge> watset = new SimplifiedWatset<String, DefaultWeightedEdge>(graph, algorithm, EmptyClustering.provider());
        watset.fit();
        return watset.getContexts();
    }
}

