/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.nlpub.watset.cli.Application;
import org.nlpub.watset.cli.ClusteringCommand;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.graph.SimplifiedWatset;
import org.nlpub.watset.graph.Watset;
import org.nlpub.watset.util.AlgorithmProvider;
import org.nlpub.watset.util.CosineContextSimilarity;

@Parameters(commandDescription="Watset")
class CommandWatset
extends ClusteringCommand {
    @Parameter(required=true, description="Local clustering algorithm", names={"-l", "--local"})
    private String local;
    @Parameter(description="Local clustering algorithm parameters", names={"-lp", "--local-params"})
    private String localParams;
    @Parameter(required=true, description="Global clustering algorithm", names={"-g", "--global"})
    private String global;
    @Parameter(description="Global clustering algorithm parameters", names={"-gp", "--global-params"})
    private String globalParams;
    @Parameter(description="Use Simplified Watset", names={"-s", "--simplified"})
    boolean simplified = false;

    public CommandWatset(Application application) {
        super(application);
    }

    @Override
    public Clustering<String> getClustering() {
        AlgorithmProvider localProvider = new AlgorithmProvider(this.local, this.localParams);
        AlgorithmProvider globalProvider = new AlgorithmProvider(this.global, this.globalParams);
        Graph<String, DefaultWeightedEdge> graph = this.application.getGraph();
        if (this.simplified) {
            return new SimplifiedWatset<String, DefaultWeightedEdge>(graph, localProvider, globalProvider);
        }
        Watset<String, DefaultWeightedEdge> watset = new Watset<String, DefaultWeightedEdge>(graph, localProvider, globalProvider, new CosineContextSimilarity());
        return watset;
    }
}

