/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.Rasterizer;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.function.Consumer;

abstract class SvgRasterizer
implements Rasterizer {
    SvgRasterizer() {
    }

    @Override
    public Format format() {
        return Format.SVG;
    }

    @Override
    public BufferedImage rasterize(Graphviz graphviz, Consumer<Graphics2D> graphicsConfigurer, String input) {
        String svg = input.replace("xlink:href=\"", "xlink:href=\"file://").replace("stroke=\"transparent\"", "stroke=\"#fff\" stroke-opacity=\"0.0\"").replace("fill=\"transparent\"", "fill=\"#fff\" fill-opacity=\"0.0\"");
        String baseDirStringOrig = graphviz.getOptions().basedir.getAbsolutePath() + File.separator;
        String baseDirString = baseDirStringOrig.replace("\\", "/");
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            svg = svg.replace("xlink:href=\"file://" + baseDirStringOrig, "xlink:href=\"file:///" + baseDirString);
        }
        return this.doRasterize(graphviz, graphicsConfigurer, svg);
    }

    abstract BufferedImage doRasterize(Graphviz var1, Consumer<Graphics2D> var2, String var3);
}

