/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.model;

import guru.nidi.graphviz.attribute.Attributed;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.ForLink;
import guru.nidi.graphviz.attribute.MapAttributes;
import guru.nidi.graphviz.model.CreationContext;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableAttributed;
import guru.nidi.graphviz.model.MutableNode;
import guru.nidi.graphviz.model.Node;
import guru.nidi.graphviz.model.Port;
import guru.nidi.graphviz.model.PortSource;
import guru.nidi.graphviz.model.SimpleMutableAttributed;

public final class Link
implements Attributed<Link, ForLink>,
LinkTarget {
    final LinkSource from;
    final LinkTarget to;
    final MutableAttributed<Link, ForLink> attributes;

    public static Link to(MutableNode node) {
        return Link.to(node.port((String)null));
    }

    public static Link to(Node node) {
        return Link.to(node.port((String)null));
    }

    public static Link to(LinkTarget to) {
        return Link.between((LinkSource)null, to);
    }

    public LinkTarget to() {
        return this.to;
    }

    public static Link between(Port port, LinkTarget to) {
        return Link.between(new PortSource(port), to);
    }

    static Link between(LinkSource from, LinkTarget to) {
        return CreationContext.createLink(from, to);
    }

    Link(LinkSource from, LinkTarget to, Attributes<? extends ForLink> attributes) {
        this.from = from;
        this.to = to;
        this.attributes = new SimpleMutableAttributed<Link, ForLink>(this, attributes);
    }

    public Link add(Attributes<? extends ForLink> attrs) {
        this.attributes.add((Attributes<ForLink>)attrs);
        return this;
    }

    @Override
    public Link with(Attributes<? extends ForLink> attrs) {
        Attributes<? extends ForLink> as = attrs.applyTo(this.attributes.copy());
        return new Link(this.from, this.to, as);
    }

    @Override
    public Attributes<? super ForLink> applyTo(MapAttributes<? super ForLink> attrs) {
        return this.attributes.applyTo(attrs);
    }

    @Override
    public Link linkTo() {
        return this;
    }

    public LinkTarget asLinkTarget() {
        return Link.to(this.from.asLinkTarget());
    }

    @Override
    public LinkSource asLinkSource() {
        return this.to.asLinkSource();
    }

    public LinkSource from() {
        return this.from;
    }

    public MutableAttributed<Link, ForLink> attrs() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return this.attributes.equals(link.attributes);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.attributes.hashCode();
        return result;
    }
}

