/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.ide.actions.CMLCodeAction;
import org.contextmapper.dsl.ide.actions.SelectionContextResolver;
import org.contextmapper.dsl.ide.actions.impl.DeriveBoundedContextFromSubdomainsAction;
import org.contextmapper.dsl.ide.actions.impl.DeriveFrontendAndBackendFromFeatureBCAction;
import org.contextmapper.dsl.ide.actions.impl.DeriveSubdomainFromUserRequirementsAction;
import org.contextmapper.dsl.ide.actions.impl.ExtractAggregatesByCohesionAction;
import org.contextmapper.dsl.ide.actions.impl.ExtractAggregatesByVolatilityAction;
import org.contextmapper.dsl.ide.actions.impl.ExtractSharedKernelAction;
import org.contextmapper.dsl.ide.actions.impl.ExtractSuggestedServiceAction;
import org.contextmapper.dsl.ide.actions.impl.MergeAggregatesAction;
import org.contextmapper.dsl.ide.actions.impl.MergeBoundedContextsAction;
import org.contextmapper.dsl.ide.actions.impl.SplitAggregateByEntitiesAction;
import org.contextmapper.dsl.ide.actions.impl.SplitBoundedContextByFeaturesAction;
import org.contextmapper.dsl.ide.actions.impl.SplitBoundedContextByOwnerAction;
import org.contextmapper.dsl.ide.actions.impl.SplitSystemIntoSubsystemsAction;
import org.contextmapper.dsl.ide.actions.impl.SuspendPartnershipAction;
import org.contextmapper.dsl.ide.actions.impl.SwitchFromPartnershipToSharedKernelAction;
import org.contextmapper.dsl.ide.actions.impl.SwitchFromSharedKernelToPartnershipAction;
import org.contextmapper.dsl.ide.edit.WorkspaceEditRecorder;
import org.contextmapper.dsl.ide.quickfix.QuickfixCommandMapper;
import org.contextmapper.dsl.ide.quickfix.impl.OpenFlowInSketchMinerCommandMapper;
import org.contextmapper.dsl.ide.quickfix.impl.SplitStoryByVerbCommandMapper;
import org.contextmapper.dsl.quickfixes.CMLQuickFix;
import org.contextmapper.dsl.quickfixes.CreateMissingBoundedContextQuickFix;
import org.contextmapper.dsl.quickfixes.SplitStoryByVerb;
import org.contextmapper.dsl.quickfixes.tactic.ExtractIDValueObjectQuickFix;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtext.ide.serializer.IChangeSerializer;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService2;

public class CMLActionRegistry {
    @Inject
    private WorkspaceEditRecorder editRecorder;
    @Inject
    private SelectionContextResolver selectionResolver;
    private Map<String, List<CMLQuickFix<? extends EObject>>> quickFixActionRegistry = Maps.newHashMap();
    private Map<String, List<QuickfixCommandMapper>> quickFixCommandRegistry = Maps.newHashMap();
    private static final String XTEXT_DIAGNOSTICS_PREFIX = "org.eclipse.xtext.diagnostics";

    public CMLActionRegistry() {
        this.registerAllQuickFixes();
    }

    private List<CMLCodeAction> getAllActions(CMLResource resource, List<EObject> selectedObjects) {
        LinkedList codeActions = Lists.newLinkedList();
        codeActions.add(new SplitBoundedContextByOwnerAction(resource, selectedObjects));
        codeActions.add(new SplitBoundedContextByFeaturesAction(resource, selectedObjects));
        codeActions.add(new SplitAggregateByEntitiesAction(resource, selectedObjects));
        codeActions.add(new DeriveSubdomainFromUserRequirementsAction(resource, selectedObjects));
        codeActions.add(new DeriveBoundedContextFromSubdomainsAction(resource, selectedObjects));
        codeActions.add(new DeriveFrontendAndBackendFromFeatureBCAction(resource, selectedObjects));
        codeActions.add(new SplitSystemIntoSubsystemsAction(resource, selectedObjects));
        codeActions.add(new ExtractAggregatesByVolatilityAction(resource, selectedObjects));
        codeActions.add(new ExtractAggregatesByCohesionAction(resource, selectedObjects));
        codeActions.add(new MergeAggregatesAction(resource, selectedObjects));
        codeActions.add(new MergeBoundedContextsAction(resource, selectedObjects));
        codeActions.add(new ExtractSharedKernelAction(resource, selectedObjects));
        codeActions.add(new SuspendPartnershipAction(resource, selectedObjects));
        codeActions.add(new SwitchFromPartnershipToSharedKernelAction(resource, selectedObjects));
        codeActions.add(new SwitchFromSharedKernelToPartnershipAction(resource, selectedObjects));
        codeActions.add(new ExtractSuggestedServiceAction(resource, selectedObjects));
        return Lists.newLinkedList((Iterable)codeActions);
    }

    private void registerAllQuickFixes() {
        this.registerActionQuickFix("primitive-id-detected", (CMLQuickFix<? extends EObject>)new ExtractIDValueObjectQuickFix());
        this.registerCommandQuickFix("split-feature-by-verb-suggestion", new SplitStoryByVerbCommandMapper((CMLQuickFix<? extends EObject>)new SplitStoryByVerb()));
        this.registerCommandQuickFix("open-flow-in-sketch-miner", new OpenFlowInSketchMinerCommandMapper());
    }

    public List<? extends Command> getApplicableActionCommands(CMLResource resource, List<EObject> selectedObjects) {
        List result = this.getAllActions(resource, selectedObjects).stream().filter(a -> a.isApplicable()).map(a -> a.getCommand()).collect(Collectors.toList());
        return result;
    }

    public List<Either<Command, CodeAction>> getApplicableQuickfixes(Diagnostic diagnostic, ICodeActionService2.Options options) {
        LinkedList quickFixCodeActions = Lists.newLinkedList();
        if (diagnostic.getCode() == null || diagnostic.getCode().get() == null || !(diagnostic.getCode().get() instanceof String)) {
            return quickFixCodeActions;
        }
        String key = (String)diagnostic.getCode().get();
        if (key.startsWith(XTEXT_DIAGNOSTICS_PREFIX)) {
            quickFixCodeActions.addAll(this.createQuickFixes4XtextDiagnostics(diagnostic, options));
        }
        quickFixCodeActions.addAll(this.createActionQuickFix4ValidationMessage(key, diagnostic, options));
        quickFixCodeActions.addAll(this.createCommandQuickFix4ValidationMessage(key, diagnostic, options));
        return quickFixCodeActions;
    }

    private List<Either<Command, CodeAction>> createActionQuickFix4ValidationMessage(String validationId, Diagnostic diagnostic, ICodeActionService2.Options options) {
        LinkedList codeActions = Lists.newLinkedList();
        if (this.quickFixActionRegistry.get(validationId) == null || this.quickFixActionRegistry.get(validationId).isEmpty()) {
            return codeActions;
        }
        for (CMLQuickFix<? extends EObject> quickFix : this.quickFixActionRegistry.get(validationId)) {
            codeActions.add(Either.forRight((Object)this.createQuickFixCodeAction(quickFix, diagnostic, options, false)));
        }
        return codeActions;
    }

    private List<Either<Command, CodeAction>> createCommandQuickFix4ValidationMessage(String validationId, Diagnostic diagnostic, ICodeActionService2.Options options) {
        LinkedList codeActions = Lists.newLinkedList();
        if (this.quickFixCommandRegistry.get(validationId) == null || this.quickFixCommandRegistry.get(validationId).isEmpty()) {
            return codeActions;
        }
        CMLResource cmlResource = new CMLResource(options.getResource());
        List<EObject> objects = this.selectionResolver.resolveAllSelectedEObjects(cmlResource, options.getDocument().getOffSet(diagnostic.getRange().getStart()), options.getDocument().getOffSet(diagnostic.getRange().getEnd()));
        if (objects.isEmpty()) {
            throw new ContextMapperApplicationException("We could not find the selected object for the triggered quickfix.");
        }
        for (QuickfixCommandMapper quickFixCommand : this.quickFixCommandRegistry.get(validationId)) {
            CodeAction action = quickFixCommand.getCodeAction(cmlResource, objects.get(0));
            LinkedList diagnostics = Lists.newLinkedList();
            diagnostics.add(diagnostic);
            action.setDiagnostics((List)diagnostics);
            codeActions.add(Either.forRight((Object)action));
        }
        return codeActions;
    }

    private CodeAction createQuickFixCodeAction(CMLQuickFix<? extends EObject> quickFix, Diagnostic diagnostic, ICodeActionService2.Options options, boolean useRootContext) {
        CodeAction action = new CodeAction(quickFix.getName());
        action.setDiagnostics(Arrays.asList(diagnostic));
        action.setKind("quickfix");
        action.setEdit(this.editRecorder.recordWorkspaceEdit(options.getLanguageServerAccess(), options.getResource().getURI(), options.getDocument(), (IChangeSerializer.IModification<Resource>)((IChangeSerializer.IModification)resource -> {
            CMLResource cmlResource = new CMLResource(resource);
            if (useRootContext) {
                quickFix.applyQuickfix2EObject((EObject)cmlResource.getContextMappingModel());
            } else {
                List<EObject> objects = this.selectionResolver.resolveAllSelectedEObjects(cmlResource, options.getDocument().getOffSet(diagnostic.getRange().getStart()), options.getDocument().getOffSet(diagnostic.getRange().getEnd()));
                if (objects.isEmpty()) {
                    throw new ContextMapperApplicationException("Selected object for quick fix could not be found.");
                }
                quickFix.applyQuickfix2EObject(EcoreUtil.resolve((EObject)objects.get(0), (Resource)resource));
            }
        })));
        return action;
    }

    private List<Either<Command, CodeAction>> createQuickFixes4XtextDiagnostics(Diagnostic diagnostic, ICodeActionService2.Options options) {
        Pattern pattern;
        Matcher matcher;
        LinkedList quickFixCodeActions = Lists.newLinkedList();
        if (diagnostic.getCode().get().equals("org.eclipse.xtext.diagnostics.Diagnostic.Linking") && diagnostic.getMessage().matches(String.format("^Couldn't resolve reference to %s '([a-zA-Z_][a-zA-Z0-9_]*)'.", "BoundedContext")) && (matcher = (pattern = Pattern.compile(String.format("^Couldn't resolve reference to %s '([a-zA-Z_][a-zA-Z0-9_]*)'.", "BoundedContext"))).matcher(diagnostic.getMessage())).find()) {
            CreateMissingBoundedContextQuickFix quickFix = new CreateMissingBoundedContextQuickFix(matcher.group(1));
            quickFixCodeActions.add(Either.forRight((Object)this.createQuickFixCodeAction((CMLQuickFix<? extends EObject>)quickFix, diagnostic, options, true)));
        }
        return quickFixCodeActions;
    }

    private void registerActionQuickFix(String validationId, CMLQuickFix<? extends EObject> quickFix) {
        if (!this.quickFixActionRegistry.containsKey(validationId)) {
            this.quickFixActionRegistry.put(validationId, Lists.newLinkedList());
        }
        this.quickFixActionRegistry.get(validationId).add(quickFix);
    }

    private void registerCommandQuickFix(String validationId, QuickfixCommandMapper actionMapper) {
        if (!this.quickFixCommandRegistry.containsKey(validationId)) {
            this.quickFixCommandRegistry.put(validationId, Lists.newLinkedList());
        }
        this.quickFixCommandRegistry.get(validationId).add(actionMapper);
    }
}

