/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.actions.impl;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.ide.actions.CMLCodeAction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.Command;

public class ExtractAggregatesByCohesionAction
implements CMLCodeAction {
    private CMLResource cmlResource;
    private List<EObject> editorSelection;

    public ExtractAggregatesByCohesionAction(CMLResource cmlResource, List<EObject> editorSelection) {
        this.cmlResource = cmlResource;
        this.editorSelection = editorSelection;
    }

    @Override
    public boolean isApplicable() {
        Set<BoundedContext> bcs = this.getSelectedSystemBoundedContexts();
        return bcs.size() == 1 && bcs.iterator().next().getAggregates().size() > 1;
    }

    @Override
    public Command getCommand() {
        BoundedContext bc = this.getSelectedSystemBoundedContext();
        LinkedList commandArguments = Lists.newLinkedList();
        commandArguments.add(this.cmlResource.getURI().toString());
        commandArguments.add(bc.getName());
        commandArguments.addAll(bc.getAggregates().stream().map(agg -> agg.getName()).collect(Collectors.toSet()));
        return new Command("Extract Aggregates By Cohesion", "cml.ar.extractAggregatesByCohesion.proxy", (List)commandArguments);
    }

    private BoundedContext getSelectedSystemBoundedContext() {
        return this.getSelectedSystemBoundedContexts().iterator().next();
    }

    private Set<BoundedContext> getSelectedSystemBoundedContexts() {
        return this.editorSelection.stream().filter(o -> o instanceof BoundedContext).map(o -> (BoundedContext)o).collect(Collectors.toSet());
    }
}

