/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.actions.impl;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.ide.actions.CMLCodeAction;
import org.contextmapper.dsl.refactoring.ExtractSuggestedService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.Command;

public class ExtractSuggestedServiceAction
implements CMLCodeAction {
    private CMLResource cmlResource;
    private List<EObject> editorSelection;

    public ExtractSuggestedServiceAction(CMLResource cmlResource, List<EObject> editorSelection) {
        this.cmlResource = cmlResource;
        this.editorSelection = editorSelection;
    }

    @Override
    public boolean isApplicable() {
        Set<BoundedContext> bcs = this.getSelectedSystemBoundedContexts();
        return this.cmlResource.getURI().lastSegment().matches(ExtractSuggestedService.SERVICE_CUTTER_SUGGESTION_FILE_NAME_PATTERN) && bcs.size() == 1;
    }

    @Override
    public Command getCommand() {
        BoundedContext bc = this.getSelectedSystemBoundedContext();
        LinkedList commandArguments = Lists.newLinkedList();
        URI originalURI = new ExtractSuggestedService(bc, "NoNameBC").constructOriginalModelUri();
        commandArguments.add(originalURI.toString());
        commandArguments.add(this.cmlResource.getURI().toString());
        commandArguments.add(bc.getName());
        return new Command("Extract Suggested Service in Original Model", "cml.ar.extractSuggestedService.proxy", (List)commandArguments);
    }

    private BoundedContext getSelectedSystemBoundedContext() {
        return this.getSelectedSystemBoundedContexts().iterator().next();
    }

    private Set<BoundedContext> getSelectedSystemBoundedContexts() {
        return this.editorSelection.stream().filter(o -> o instanceof BoundedContext).map(o -> (BoundedContext)o).collect(Collectors.toSet());
    }
}

