/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.commands.impl.quickfix;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.HashSet;
import java.util.Set;
import org.contextmapper.dsl.cml.CMLResource;
import org.contextmapper.dsl.contextMappingDSL.UserRequirement;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.ide.commands.impl.quickfix.AbstractQuickFixCommand;
import org.contextmapper.dsl.ide.edit.WorkspaceEditRecorder;
import org.contextmapper.dsl.quickfixes.CMLQuickFix;
import org.contextmapper.dsl.quickfixes.SplitStoryByVerb;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsp4j.ExecuteCommandParams;

public class SplitStoryByVerbCommand
extends AbstractQuickFixCommand {
    public SplitStoryByVerbCommand(WorkspaceEditRecorder editRecorder) {
        super(editRecorder);
    }

    @Override
    protected CMLQuickFix<? extends EObject> getQuickfix(ExecuteCommandParams params) {
        JsonArray quickFixParams = (JsonArray)params.getArguments().get(1);
        JsonArray selectedVerbs = (JsonArray)quickFixParams.get(1);
        HashSet verbs = Sets.newHashSet();
        for (JsonElement element : selectedVerbs) {
            verbs.add(element.getAsString());
        }
        SplitStoryByVerb qf = new SplitStoryByVerb();
        qf.setVerbs((Set)verbs);
        return qf;
    }

    @Override
    protected EObject getSubject(CMLResource cmlResource, ExecuteCommandParams params) {
        JsonArray quickFixParams = (JsonArray)params.getArguments().get(1);
        JsonPrimitive storyName = (JsonPrimitive)quickFixParams.get(0);
        UserRequirement story = cmlResource.getContextMappingModel().getUserRequirements().stream().filter(ur -> ur.getName().equals(storyName.getAsString())).findFirst().get();
        if (story.getFeatures().size() != 1) {
            throw new ContextMapperApplicationException("Wrong validation implementation! This quickfix is only applicable to user stories with one and only one 'I want to' parts (features).");
        }
        return (EObject)story.getFeatures().get(0);
    }
}

