/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.ide.commands.impl.refactoring;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.LinkedList;
import java.util.List;
import org.contextmapper.dsl.ide.commands.impl.refactoring.AbstractRefactoringCommand;
import org.contextmapper.dsl.ide.edit.WorkspaceEditRecorder;
import org.contextmapper.dsl.refactoring.ExtractAggregatesByCohesion;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.eclipse.lsp4j.ExecuteCommandParams;

public class ExtractAggregatesByCohesionCommand
extends AbstractRefactoringCommand {
    public ExtractAggregatesByCohesionCommand(WorkspaceEditRecorder editRecorder) {
        super(editRecorder);
    }

    @Override
    protected SemanticCMLRefactoring getRefactoring(ExecuteCommandParams params) {
        JsonArray refactoringParams = (JsonArray)params.getArguments().get(1);
        JsonPrimitive boundedContextName = (JsonPrimitive)refactoringParams.get(0);
        JsonPrimitive newBoundedContextName = (JsonPrimitive)refactoringParams.get(1);
        JsonArray aggregatesToExtract = (JsonArray)refactoringParams.get(2);
        LinkedList aggregateNames = Lists.newLinkedList();
        for (JsonElement element : aggregatesToExtract) {
            aggregateNames.add(element.getAsString());
        }
        return new ExtractAggregatesByCohesion(boundedContextName.getAsString(), newBoundedContextName.getAsString(), (List)aggregateNames);
    }
}

