/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.servicecutter.input.converter;

import ch.hsr.servicecutter.api.model.Entity;
import ch.hsr.servicecutter.api.model.EntityRelation;
import ch.hsr.servicecutter.api.model.EntityRelationDiagram;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.tactic.dsl.tacticdsl.Attribute;
import org.contextmapper.tactic.dsl.tacticdsl.DomainEvent;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.Enum;
import org.contextmapper.tactic.dsl.tacticdsl.Event;
import org.contextmapper.tactic.dsl.tacticdsl.Reference;
import org.contextmapper.tactic.dsl.tacticdsl.SimpleDomainObject;
import org.contextmapper.tactic.dsl.tacticdsl.ValueObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class ContextMappingModelToServiceCutterERDConverter {
    private EntityRelationDiagram target;
    private Map<String, DomainObject> dslEntityLookupTable = new HashMap<String, DomainObject>();
    private Map<String, Entity> entityLookupTable = new HashMap<String, Entity>();

    public EntityRelationDiagram convert(String modelName, ContextMappingModel cmlModel) {
        this.target = new EntityRelationDiagram();
        this.target.setName(modelName);
        this.target.setEntities(new ArrayList());
        this.target.setRelations(new ArrayList());
        this.initializeEntityLookupTable(cmlModel);
        for (BoundedContext bc : cmlModel.getBoundedContexts()) {
            this.mapBoundedContext(bc);
        }
        this.mapReferences4DomainObjects(EcoreUtil2.getAllContentsOfType((EObject)cmlModel, SimpleDomainObject.class));
        return this.target;
    }

    private void mapBoundedContext(BoundedContext bc) {
        Entity boundedContextEntity = new Entity(bc.getName() + "_BC");
        List allAggregates = EcoreUtil2.eAllOfType((EObject)bc, Aggregate.class);
        for (Aggregate aggregate : allAggregates) {
            EntityRelation entityRelation = new EntityRelation();
            entityRelation.setOrigin(boundedContextEntity);
            entityRelation.setDestination(this.mapAggregate(aggregate));
            entityRelation.setType(EntityRelation.RelationType.AGGREGATION);
            this.target.getRelations().add(entityRelation);
        }
        this.target.getEntities().add(boundedContextEntity);
    }

    private Entity mapAggregate(Aggregate aggregate) {
        Entity aggregrateEntity = new Entity(aggregate.getName() + "_Aggregate");
        for (SimpleDomainObject simpleDomainObject : aggregate.getDomainObjects()) {
            if (!this.isDomainObjectUsed4ServiceCutter(simpleDomainObject)) continue;
            DomainObject dslDomainObject = (DomainObject)simpleDomainObject;
            EntityRelation relation = new EntityRelation();
            relation.setOrigin(aggregrateEntity);
            relation.setDestination(this.mapDomainObject(dslDomainObject));
            relation.setType(EntityRelation.RelationType.AGGREGATION);
            this.target.getRelations().add(relation);
        }
        this.target.getEntities().add(aggregrateEntity);
        return aggregrateEntity;
    }

    private boolean isDomainObjectUsed4ServiceCutter(SimpleDomainObject simpleDomainObject) {
        return simpleDomainObject instanceof org.contextmapper.tactic.dsl.tacticdsl.Entity || simpleDomainObject instanceof Event || simpleDomainObject instanceof ValueObject;
    }

    private Entity mapDomainObject(DomainObject dslDomainObject) {
        Entity entityEntity = this.getEntity(dslDomainObject.getName());
        entityEntity.setNanoentities(new ArrayList());
        for (Attribute attribute : dslDomainObject.getAttributes()) {
            entityEntity.getNanoentities().add(attribute.getName());
        }
        for (Reference reference : dslDomainObject.getReferences()) {
            entityEntity.getNanoentities().add(reference.getName());
        }
        this.target.getEntities().add(entityEntity);
        return entityEntity;
    }

    private void mapReferences4DomainObjects(Collection<SimpleDomainObject> domainObjects) {
        for (SimpleDomainObject domainObject : domainObjects) {
            if (!this.isDomainObjectUsed4ServiceCutter(domainObject)) continue;
            this.mapReferences((DomainObject)domainObject, (Collection<Reference>)((DomainObject)domainObject).getReferences());
        }
    }

    private void mapReferences(DomainObject sourceObject, Collection<Reference> references) {
        for (Reference reference : references) {
            if (reference.getDomainObjectType() instanceof Enum) {
                this.entityLookupTable.get(sourceObject.getName()).getNanoentities().add(reference.getName());
                continue;
            }
            String refType = reference.getDomainObjectType().getName();
            if (!this.dslEntityLookupTable.containsKey(refType)) continue;
            EntityRelation relation = new EntityRelation();
            relation.setOrigin(this.entityLookupTable.get(sourceObject.getName()));
            relation.setDestination(this.getEntity(refType));
            relation.setType(EntityRelation.RelationType.AGGREGATION);
            this.target.getRelations().add(relation);
        }
    }

    private void initializeEntityLookupTable(ContextMappingModel cmlModel) {
        this.addDomainObjectToLookupTable(EcoreUtil2.getAllContentsOfType((EObject)cmlModel, org.contextmapper.tactic.dsl.tacticdsl.Entity.class));
        this.addDomainObjectToLookupTable(EcoreUtil2.getAllContentsOfType((EObject)cmlModel, DomainEvent.class));
        this.addDomainObjectToLookupTable(EcoreUtil2.getAllContentsOfType((EObject)cmlModel, ValueObject.class));
    }

    private void addDomainObjectToLookupTable(List<? extends DomainObject> domainObjects) {
        for (DomainObject domainObject : domainObjects) {
            this.dslEntityLookupTable.put(domainObject.getName(), domainObject);
        }
    }

    private Entity getEntity(String name) {
        if (this.entityLookupTable.containsKey(name)) {
            return this.entityLookupTable.get(name);
        }
        Entity entity = new Entity(name);
        this.entityLookupTable.put(name, entity);
        return entity;
    }
}

