/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.generator.sketchminer.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.exception.ContextMapperApplicationException;
import org.contextmapper.dsl.generator.sketchminer.model.TaskType;

public class Task {
    private String name;
    private TaskType type;
    private List<Task> parallelTasks;
    private String comment;
    private String actor;

    public Task(String name, TaskType type) {
        if (name == null || "".equals(name)) {
            throw new ContextMapperApplicationException("No valid event or command name passed.");
        }
        this.name = name;
        this.type = type;
    }

    public Task(String name, TaskType type, List<Task> parallelTasks) {
        this(name, type);
        this.parallelTasks = Lists.newLinkedList(parallelTasks);
    }

    public String getName() {
        return this.name;
    }

    public TaskType getType() {
        return this.type;
    }

    public Set<Task> getParallelTasks() {
        if (this.parallelTasks == null) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet(this.parallelTasks);
    }

    public boolean equalsOrContainsTask(Task otherTask) {
        return otherTask.name.equals(this.name) || this.parallelTasks != null && this.parallelTasks.stream().map(t -> t.getName()).collect(Collectors.toList()).contains(otherTask.getName());
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public String getActor() {
        return this.actor;
    }

    private Set<String> getAllTaskNames() {
        HashSet names = Sets.newHashSet();
        names.add(this.name);
        if (this.parallelTasks != null) {
            names.addAll(this.parallelTasks.stream().map(t -> t.getName()).collect(Collectors.toSet()));
        }
        return names;
    }

    public String toString() {
        if (this.parallelTasks == null || this.parallelTasks.isEmpty()) {
            return this.name;
        }
        return String.join((CharSequence)"|", this.getAllTaskNames().stream().sorted().collect(Collectors.toList()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parallelTasks == null ? 0 : this.parallelTasks.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Task other = (Task)obj;
        return this.getAllTaskNames().equals(other.getAllTaskNames());
    }
}

