/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.Relationship;
import org.contextmapper.dsl.contextMappingDSL.SculptorModule;
import org.contextmapper.dsl.contextMappingDSL.UpstreamDownstreamRelationship;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;
import org.contextmapper.dsl.refactoring.exception.RefactoringInputException;
import org.contextmapper.tactic.dsl.tacticdsl.DomainObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class MergeAggregatesRefactoring
extends AbstractRefactoring
implements SemanticCMLRefactoring {
    private String aggregate1;
    private String aggregate2;
    private boolean takeAttributesFromSecondAggregate = false;

    public MergeAggregatesRefactoring(String aggregate1, String aggregate2) {
        this.aggregate1 = aggregate1;
        this.aggregate2 = aggregate2;
    }

    public MergeAggregatesRefactoring(String aggregate1, String aggregate2, boolean takeAttributesFromSecondAggregate) {
        this(aggregate1, aggregate2);
        this.takeAttributesFromSecondAggregate = takeAttributesFromSecondAggregate;
    }

    @Override
    protected void doRefactor() {
        if (this.aggregate1.equals(this.aggregate2)) {
            return;
        }
        Optional<Aggregate> agg1Opt = this.getAllAggregates().stream().filter(bc -> bc.getName().equals(this.aggregate1)).findFirst();
        Optional<Aggregate> agg2Opt = this.getAllAggregates().stream().filter(bc -> bc.getName().equals(this.aggregate2)).findFirst();
        if (!agg1Opt.isPresent() || !agg2Opt.isPresent()) {
            return;
        }
        Aggregate agg1 = agg1Opt.get();
        Aggregate agg2 = agg2Opt.get();
        if (this.takeAttributesFromSecondAggregate) {
            agg1 = agg2Opt.get();
            agg2 = agg1Opt.get();
        }
        this.checkForPossibleDomainObjectNameClashes(agg1, agg2);
        if (this.containsAggregateRoot(agg1)) {
            this.changeAggregateRootsToNormalObjects(agg2);
        }
        this.addElementsToEList(agg1.getConsumers(), agg2.getConsumers());
        this.addElementsToEList(agg1.getDomainObjects(), agg2.getDomainObjects());
        this.addElementsToEList(agg1.getResources(), agg2.getResources());
        this.addElementsToEList(agg1.getResponsibilities(), agg2.getResponsibilities());
        this.addElementsToEList(agg1.getServices(), agg2.getServices());
        this.addElementsToEList(agg1.getUserRequirements(), agg2.getUserRequirements());
        for (ContextMap contextMap : this.getAllContextMaps()) {
            this.handleContextMapChanges(contextMap, agg1, agg2);
        }
        if (agg2.eContainer() instanceof BoundedContext) {
            BoundedContext container = (BoundedContext)agg2.eContainer();
            this.removeElementFromEList(container.getAggregates(), agg2);
        } else if (agg2.eContainer() instanceof SculptorModule) {
            this.removeElementFromEList(((SculptorModule)agg2.eContainer()).getAggregates(), agg2);
        }
    }

    private void checkForPossibleDomainObjectNameClashes(Aggregate aggregate1, Aggregate aggregate2) {
        List aggregate1DomainObjectNames = aggregate1.getDomainObjects().stream().map(obj -> obj.getName()).collect(Collectors.toList());
        List aggregate2DomainObjectNames = aggregate2.getDomainObjects().stream().map(obj -> obj.getName()).collect(Collectors.toList());
        Set commonDomainObjectNames = aggregate1DomainObjectNames.stream().distinct().filter(aggregate2DomainObjectNames::contains).collect(Collectors.toSet());
        if (!commonDomainObjectNames.isEmpty()) {
            throw new RefactoringInputException("Sorry, we cannot execute this refactoring. The selected Aggregates contain the following duplicate domain objects: " + String.join((CharSequence)", ", commonDomainObjectNames));
        }
    }

    private void changeAggregateRootsToNormalObjects(Aggregate aggregate) {
        this.getAggregateRoots(aggregate).forEach(o -> o.setAggregateRoot(false));
    }

    private boolean containsAggregateRoot(Aggregate aggregate) {
        return !this.getAggregateRoots(aggregate).isEmpty();
    }

    private List<DomainObject> getAggregateRoots(Aggregate aggregate) {
        return aggregate.getDomainObjects().stream().filter(o -> o instanceof DomainObject).map(o -> (DomainObject)o).filter(o -> o.isAggregateRoot()).collect(Collectors.toList());
    }

    private List<Aggregate> getAllAggregates() {
        ArrayList aggregates = Lists.newArrayList();
        for (BoundedContext bc : this.getAllBoundedContexts()) {
            aggregates.addAll(EcoreUtil2.getAllContentsOfType((EObject)bc, Aggregate.class));
        }
        return aggregates;
    }

    private void handleContextMapChanges(ContextMap map, Aggregate agg1, Aggregate agg2) {
        for (Relationship relationship : map.getRelationships()) {
            UpstreamDownstreamRelationship upDownRelationship;
            if (!(relationship instanceof UpstreamDownstreamRelationship) || !(upDownRelationship = (UpstreamDownstreamRelationship)relationship).getUpstreamExposedAggregates().contains((Object)agg2)) continue;
            ArrayList exposedAggregates = Lists.newArrayList();
            exposedAggregates.addAll(upDownRelationship.getUpstreamExposedAggregates());
            exposedAggregates.remove(agg2);
            exposedAggregates.add(agg1);
            upDownRelationship.getUpstreamExposedAggregates().clear();
            upDownRelationship.getUpstreamExposedAggregates().addAll((Collection)exposedAggregates);
        }
    }
}

