/*
 * Decompiled with CFR 0.152.
 */
package org.contextmapper.dsl.refactoring;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.contextmapper.dsl.contextMappingDSL.Aggregate;
import org.contextmapper.dsl.contextMappingDSL.BoundedContext;
import org.contextmapper.dsl.contextMappingDSL.ContextMap;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingDSLFactory;
import org.contextmapper.dsl.contextMappingDSL.ContextMappingModel;
import org.contextmapper.dsl.refactoring.AbstractRefactoring;
import org.contextmapper.dsl.refactoring.CompoundKey;
import org.contextmapper.dsl.refactoring.ContextMappingModelHelper;
import org.contextmapper.dsl.refactoring.SemanticCMLRefactoring;

public class SplitBoundedContextByAggregateAttribute
extends AbstractRefactoring
implements SemanticCMLRefactoring {
    private String boundedContextName;
    private BoundedContext originalBC;
    private Map<CompoundKey, List<Aggregate>> splittingKeyToAggregatesMapping;
    private Function<Aggregate, CompoundKey> aggregateToSetKeyMappingFunction;

    public SplitBoundedContextByAggregateAttribute(Function<Aggregate, CompoundKey> aggregateToSetKeyMappingFunction, String boundedContextName) {
        this.aggregateToSetKeyMappingFunction = aggregateToSetKeyMappingFunction;
        this.boundedContextName = boundedContextName;
    }

    @Override
    public void doRefactor() {
        this.initOriginalBC();
        this.createAggregateMapping();
        this.splitOriginalBC();
    }

    private void createAggregateMapping() {
        this.splittingKeyToAggregatesMapping = new HashMap<CompoundKey, List<Aggregate>>();
        for (Aggregate aggregate : this.originalBC.getAggregates()) {
            CompoundKey splittingGroupKey = this.aggregateToSetKeyMappingFunction.apply(aggregate);
            if (this.splittingKeyToAggregatesMapping.containsKey(splittingGroupKey)) {
                this.splittingKeyToAggregatesMapping.get(splittingGroupKey).add(aggregate);
                continue;
            }
            this.splittingKeyToAggregatesMapping.put(splittingGroupKey, Lists.newArrayList((Object[])new Aggregate[]{aggregate}));
        }
    }

    private void splitOriginalBC() {
        if (this.splittingKeyToAggregatesMapping.size() <= 1) {
            return;
        }
        Iterator<Map.Entry<CompoundKey, List<Aggregate>>> it = this.splittingKeyToAggregatesMapping.entrySet().iterator();
        it.next();
        int i = 1;
        while (it.hasNext()) {
            List<Aggregate> aggregates = it.next().getValue();
            this.originalBC.getAggregates().removeAll(aggregates);
            ContextMappingModel bcModel = this.getResource(this.originalBC).getContextMappingModel();
            BoundedContext newBC = ContextMappingDSLFactory.eINSTANCE.createBoundedContext();
            newBC.setName("NewBoundedContext" + i++);
            this.addElementsToEList(newBC.getAggregates(), aggregates);
            this.addElementToEList(bcModel.getBoundedContexts(), newBC);
            this.adjustContextMaps(newBC, aggregates);
        }
    }

    private void initOriginalBC() {
        Set<BoundedContext> allBCs = this.getAllBoundedContexts();
        Set bcsWithGivenInputName = allBCs.stream().filter(bc -> bc.getName().equals(this.boundedContextName)).collect(Collectors.toSet());
        this.originalBC = (BoundedContext)bcsWithGivenInputName.iterator().next();
    }

    private void adjustContextMaps(BoundedContext newBC, List<Aggregate> extractedAggregates) {
        for (ContextMap contextMap : this.getAllContextMaps()) {
            new ContextMappingModelHelper(contextMap).moveExposedAggregatesToNewRelationshipsIfNeeded(extractedAggregates.stream().map(agg -> agg.getName()).collect(Collectors.toList()), newBC);
        }
    }
}

