/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm.generator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.graphstream.algorithm.generator.BaseGenerator;

public class BarabasiAlbertGenerator
extends BaseGenerator {
    protected ArrayList<Integer> degrees;
    protected int maxLinksPerStep;
    protected boolean exactlyMaxLinksPerStep = false;
    protected int sumDeg;
    protected int sumDegRemaining;
    protected Set<Integer> connected;

    public BarabasiAlbertGenerator() {
        this(1, false);
    }

    public BarabasiAlbertGenerator(int maxLinksPerStep) {
        this(maxLinksPerStep, false);
    }

    public BarabasiAlbertGenerator(int maxLinksPerStep, boolean exactlyMaxLinksPerStep) {
        this.directed = false;
        this.maxLinksPerStep = maxLinksPerStep;
        this.exactlyMaxLinksPerStep = exactlyMaxLinksPerStep;
    }

    public int getMaxLinksPerStep() {
        return this.maxLinksPerStep;
    }

    public boolean produceExactlyMaxLinkPerStep() {
        return this.exactlyMaxLinksPerStep;
    }

    public void setMaxLinksPerStep(int max) {
        this.maxLinksPerStep = max > 0 ? max : 1;
    }

    public void setExactlyMaxLinksPerStep(boolean on) {
        this.exactlyMaxLinksPerStep = on;
    }

    @Override
    public void begin() {
        this.addNode("0");
        this.addNode("1");
        this.addEdge("0_1", "0", "1");
        this.degrees = new ArrayList();
        this.degrees.add(1);
        this.degrees.add(1);
        this.sumDeg = 2;
        this.connected = new HashSet<Integer>();
    }

    @Override
    public boolean nextEvents() {
        int nodeCount = this.degrees.size();
        String newId = nodeCount + "";
        this.addNode(newId);
        int n = this.maxLinksPerStep;
        if (!this.exactlyMaxLinksPerStep) {
            n = this.random.nextInt(n) + 1;
        }
        n = Math.min(n, nodeCount);
        this.sumDegRemaining = this.sumDeg;
        for (int i = 0; i < n; ++i) {
            this.chooseAnotherNode();
        }
        for (int i : this.connected) {
            this.addEdge(newId + "_" + i, newId, i + "");
            this.degrees.set(i, this.degrees.get(i) + 1);
        }
        this.connected.clear();
        this.degrees.add(n);
        this.sumDeg += 2 * n;
        return true;
    }

    protected void chooseAnotherNode() {
        int r = this.random.nextInt(this.sumDegRemaining);
        int runningSum = 0;
        int i = 0;
        while (runningSum <= r) {
            if (!this.connected.contains(i)) {
                runningSum += this.degrees.get(i).intValue();
            }
            ++i;
        }
        this.connected.add(--i);
        this.sumDegRemaining -= this.degrees.get(i).intValue();
    }

    @Override
    public void end() {
        this.degrees.clear();
        this.degrees = null;
        this.connected = null;
        super.end();
    }
}

