/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.AsUnmodifiableGraph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.nlpub.watset.graph.Clustering;

public class MaxMax<V, E>
implements Clustering<V> {
    private final Graph<V, E> graph;
    private Graph<V, DefaultEdge> digraph;
    private Map<V, Set<V>> maximals;
    private Map<V, Boolean> roots;

    public static <V, E> Function<Graph<V, E>, Clustering<V>> provider() {
        return MaxMax::new;
    }

    public MaxMax(Graph<V, E> graph) {
        this.graph = Objects.requireNonNull(graph);
    }

    @Override
    public void fit() {
        this.digraph = new DefaultDirectedGraph(DefaultEdge.class);
        this.maximals = null;
        this.roots = null;
        this.graph.vertexSet().forEach(arg_0 -> this.digraph.addVertex(arg_0));
        this.maximals = this.digraph.vertexSet().stream().collect(Collectors.toMap(Function.identity(), v -> new HashSet()));
        this.digraph.vertexSet().forEach(u -> {
            double max = this.graph.edgesOf(u).stream().mapToDouble(arg_0 -> this.graph.getEdgeWeight(arg_0)).max().orElse(-1.0);
            this.graph.edgesOf(u).stream().filter(e -> this.graph.getEdgeWeight(e) == max).map(e -> Graphs.getOppositeVertex(this.graph, (Object)e, (Object)u)).forEach(v -> this.maximals.get(u).add(v));
        });
        this.graph.edgeSet().forEach(e -> {
            Object u = this.graph.getEdgeSource(e);
            Object v = this.graph.getEdgeTarget(e);
            if (this.maximals.get(u).contains(v)) {
                this.digraph.addEdge(v, u);
            }
            if (this.maximals.get(v).contains(u)) {
                this.digraph.addEdge(u, v);
            }
        });
        this.roots = this.digraph.vertexSet().stream().collect(Collectors.toMap(Function.identity(), v -> true));
        HashSet visited = new HashSet();
        this.digraph.vertexSet().forEach(v -> {
            if (this.roots.get(v).booleanValue()) {
                LinkedList queue = new LinkedList(Graphs.successorListOf(this.digraph, (Object)v));
                visited.add(v);
                while (!queue.isEmpty()) {
                    Object u = queue.remove();
                    if (visited.contains(u)) continue;
                    this.roots.put((Boolean)u, false);
                    visited.add(u);
                    queue.addAll(Graphs.successorListOf(this.digraph, u));
                }
            }
        });
    }

    @Override
    public Collection<Collection<V>> getClusters() {
        Objects.requireNonNull(this.roots, "call fit() first");
        Set roots = this.roots.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        return roots.stream().map(root -> {
            HashSet visited = new HashSet();
            LinkedList<Object> queue = new LinkedList<Object>();
            queue.add(root);
            while (!queue.isEmpty()) {
                Object v = queue.remove();
                if (visited.contains(v)) continue;
                visited.add(v);
                queue.addAll(Graphs.successorListOf(this.digraph, v));
            }
            return visited;
        }).collect(Collectors.toSet());
    }

    public Graph<V, DefaultEdge> getDigraph() {
        return new AsUnmodifiableGraph(Objects.requireNonNull(this.digraph, "call fit() first"));
    }

    public Map<V, Set<V>> getMaximals() {
        return Collections.unmodifiableMap(Objects.requireNonNull(this.maximals, "call fit() first"));
    }

    public Map<V, Boolean> getRoots() {
        return Collections.unmodifiableMap(Objects.requireNonNull(this.roots, "call fit() first"));
    }
}

