/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.Map;
import org.jgrapht.Graph;

@FunctionalInterface
public interface NodeWeighting<V, E> {
    public double apply(Graph<V, E> var1, Map<V, Integer> var2, V var3, V var4);

    public static <V, E> NodeWeighting<V, E> label() {
        return new LabelNodeWeighting();
    }

    public static <V, E> NodeWeighting<V, E> top() {
        return new TopNodeWeighting();
    }

    public static <V, E> NodeWeighting<V, E> log() {
        return new LogNodeWeighting();
    }

    public static <V, E> NodeWeighting<V, E> linear() {
        return new LinearNodeWeighting();
    }

    public static class LinearNodeWeighting<V, E>
    implements NodeWeighting<V, E> {
        @Override
        public double apply(Graph<V, E> graph, Map<V, Integer> labels, V node, V neighbor) {
            return graph.getEdgeWeight(graph.getEdge(node, neighbor)) / (double)graph.degreeOf(neighbor);
        }
    }

    public static class LogNodeWeighting<V, E>
    implements NodeWeighting<V, E> {
        @Override
        public double apply(Graph<V, E> graph, Map<V, Integer> labels, V node, V neighbor) {
            return graph.getEdgeWeight(graph.getEdge(node, neighbor)) / Math.log1p(graph.degreeOf(neighbor));
        }
    }

    public static class TopNodeWeighting<V, E>
    implements NodeWeighting<V, E> {
        @Override
        public double apply(Graph<V, E> graph, Map<V, Integer> labels, V node, V neighbor) {
            return graph.getEdgeWeight(graph.getEdge(node, neighbor));
        }
    }

    public static class LabelNodeWeighting<V, E>
    implements NodeWeighting<V, E> {
        @Override
        public double apply(Graph<V, E> graph, Map<V, Integer> labels, V node, V neighbor) {
            return labels.get(node).intValue();
        }
    }
}

