/*
 * Decompiled with CFR 0.152.
 */
package org.nlpub.watset.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jgrapht.Graph;
import org.nlpub.watset.graph.Clustering;
import org.nlpub.watset.util.Neighbors;

public class SenseInduction<V, E> {
    private final Graph<V, E> graph;
    private final Function<Graph<V, E>, Clustering<V>> local;

    public SenseInduction(Graph<V, E> graph, Function<Graph<V, E>, Clustering<V>> local) {
        this.graph = Objects.requireNonNull(graph);
        this.local = Objects.requireNonNull(local);
    }

    public Collection<Collection<V>> clusters(V target) {
        Graph<V, E> ego = Neighbors.neighborhoodGraph(this.graph, Objects.requireNonNull(target));
        Clustering<V> clustering = this.local.apply(ego);
        clustering.fit();
        return clustering.getClusters();
    }

    public List<Map<V, Number>> contexts(V target) {
        Collection<Collection<V>> clusters = this.clusters(target);
        ArrayList<Map<V, Number>> senses = new ArrayList<Map<V, Number>>(clusters.size());
        for (Collection<V> cluster : clusters) {
            HashMap<V, Double> context = new HashMap<V, Double>(cluster.size());
            for (V neighbor : cluster) {
                context.put(neighbor, this.graph.getEdgeWeight(this.graph.getEdge(target, neighbor)));
            }
            senses.add(context);
        }
        return senses;
    }
}

