/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.view.util;

import java.awt.geom.Point2D;
import org.graphstream.ui.geom.Point2;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.geom.Vector2;

public class CubicCurve {
    public static double eval(double x0, double x1, double x2, double x3, double t) {
        double tt = 1.0 - t;
        return x0 * (tt * tt * tt) + 3.0 * x1 * t * (tt * tt) + 3.0 * x2 * (t * t) * tt + x3 * (t * t * t);
    }

    public static Point2 eval(Point2 p0, Point2 p1, Point2 p2, Point2 p3, double t) {
        return new Point2(CubicCurve.eval(p0.x, p1.x, p2.x, p3.x, t), CubicCurve.eval(p0.y, p1.y, p2.y, p3.y, t));
    }

    public static Point2D.Double eval(Point2D.Double p0, Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, double t) {
        return new Point2D.Double(CubicCurve.eval(p0.x, p1.x, p2.x, p3.x, t), CubicCurve.eval(p0.y, p1.y, p2.y, p3.y, t));
    }

    public static Point2 eval(Point2 p0, Point2 p1, Point2 p2, Point2 p3, double t, Point2 result) {
        result.set(CubicCurve.eval(p0.x, p1.x, p2.x, p3.x, t), CubicCurve.eval(p0.y, p1.y, p2.y, p3.y, t));
        return result;
    }

    public static double derivative(double x0, double x1, double x2, double x3, double t) {
        return 3.0 * (x3 - 3.0 * x2 + 3.0 * x1 - x0) * t * t + 2.0 * (3.0 * x2 - 6.0 * x1 + 3.0 * x0) * t + (3.0 * x1 - 3.0 * x0);
    }

    public static Point2 derivative(Point2 p0, Point2 p1, Point2 p2, Point3 p3, double t) {
        return new Point2(CubicCurve.derivative(p0.x, p1.x, p2.x, p3.x, t), CubicCurve.derivative(p0.y, p1.y, p2.y, p3.y, t));
    }

    public static Point2 derivative(Point2 p0, Point2 p1, Point2 p2, Point3 p3, double t, Point2 result) {
        result.set(CubicCurve.derivative(p0.x, p1.x, p2.x, p3.x, t), CubicCurve.derivative(p0.y, p1.y, p2.y, p3.y, t));
        return result;
    }

    public static Vector2 perpendicular(Point2 p0, Point2 p1, Point2 p2, Point2 p3, double t) {
        return new Vector2(CubicCurve.derivative(p0.y, p1.y, p2.y, p3.y, t), -CubicCurve.derivative(p0.x, p1.x, p2.x, p3.x, t));
    }

    public static Vector2 perpendicular(Point2 p0, Point2 p1, Point2 p2, Point2 p3, double t, Vector2 result) {
        result.set(CubicCurve.derivative(p0.y, p1.y, p2.y, p3.y, t), -CubicCurve.derivative(p0.x, p1.x, p2.x, p3.x, t));
        return result;
    }

    public static Point2D.Double perpendicular(Point2D.Double p0, Point2D.Double p1, Point2D.Double p2, Point2D.Double p3, double t) {
        return new Point2D.Double(CubicCurve.derivative(p0.y, p1.y, p2.y, p3.y, t), -CubicCurve.derivative(p0.x, p1.x, p2.x, p3.x, t));
    }
}

